/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.AuthorizationRequiredException;
import com.meterware.httpunit.Base64;
import com.meterware.httpunit.HttpHeader;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class AuthenticationChallenge
extends HttpHeader {
    private WebClient _client;
    private WebRequest _request;
    private static final AuthenticationStrategy BASIC_AUTHENTICATION = new BasicAuthenticationStrategy();
    private static final AuthenticationStrategy DIGEST_AUTHENTICATION = new DigestAuthenticationStrategy();

    static AuthorizationRequiredException createException(String wwwAuthenticateHeader) {
        AuthenticationChallenge challenge = new AuthenticationChallenge(null, null, wwwAuthenticateHeader);
        return challenge.createAuthorizationRequiredException();
    }

    AuthenticationChallenge(WebClient client, WebRequest request, String headerString) {
        super(headerString, "Basic");
        this._client = client;
        this._request = request;
    }

    boolean needToAuthenticate() {
        if (this.getAuthenticationType() == null) {
            return false;
        }
        if (this.getCredentialsForRealm() != null) {
            return true;
        }
        if (!this._client.getExceptionsThrownOnErrorStatus()) {
            return false;
        }
        throw this.createAuthorizationRequiredException();
    }

    private String getAuthenticationType() {
        return this.getLabel();
    }

    String createAuthenticationHeader() {
        PasswordAuthentication credentials = this.getCredentialsForRealm();
        return this.getAuthenticationStrategy().createAuthenticationHeader(this, credentials.getUserName(), new String(credentials.getPassword()));
    }

    private AuthenticationStrategy getAuthenticationStrategy() {
        if (this.getAuthenticationType().equalsIgnoreCase("basic")) {
            return BASIC_AUTHENTICATION;
        }
        if (this.getAuthenticationType().equalsIgnoreCase("digest")) {
            return DIGEST_AUTHENTICATION;
        }
        throw new RuntimeException("Unsupported authentication type '" + this.getAuthenticationType() + "'");
    }

    private AuthorizationRequiredException createAuthorizationRequiredException() {
        return AuthorizationRequiredException.createException(this.getAuthenticationType(), this.getProperties());
    }

    private PasswordAuthentication getCredentialsForRealm() {
        return this._client.getCredentialsForRealm(this.getProperty("realm"));
    }

    private String getMethod() {
        return null == this._request ? null : this._request.getMethod();
    }

    private String getRequestUri() {
        try {
            return null == this._request ? null : this._request.getURL().getFile();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static class DigestAuthenticationStrategy
    implements AuthenticationStrategy {
        private DigestAuthenticationStrategy() {
        }

        @Override
        public String createAuthenticationHeader(AuthenticationChallenge challenge, String userName, String password) {
            StringBuffer sb = new StringBuffer("Digest ");
            Algorithm algorithm = new Algorithm();
            algorithm.appendParams(sb, challenge, userName, password);
            return sb.toString();
        }

        private class QopAlgorithm
        extends Algorithm {
            private QopAlgorithm() {
            }

            @Override
            protected void appendDigestParams(StringBuffer sb, String realm, String nonce, String uri, String userName, String password, String method, String opaque) {
                super.appendDigestParams(sb, realm, nonce, uri, userName, password, method, opaque);
            }

            @Override
            protected String getResponse(String userName, String realm, String password, String nonce, String uri, String method) {
                try {
                    String a1 = this.A1(userName, password, realm, nonce);
                    String a2 = this.A2(uri, method);
                    String ha1 = this.H(a1);
                    String ha2 = this.H(a2);
                    return this.KD(ha1, nonce + ":" + ha2);
                }
                catch (NoSuchAlgorithmException e) {
                    return "";
                }
                catch (UnsupportedEncodingException e) {
                    return "";
                }
            }

            @Override
            protected String A1(String userName, String password, String realm, String nonce) throws NoSuchAlgorithmException, UnsupportedEncodingException {
                return this.H(userName + ":" + realm + ":" + password) + ":" + nonce + ":" + this.getCNonce();
            }

            private String getCNonce() {
                return ":";
            }

            @Override
            protected String A2(String uri, String method) {
                return super.A2(uri, method);
            }
        }

        private class Algorithm {
            private Algorithm() {
            }

            public void appendParams(StringBuffer sb, AuthenticationChallenge challenge, String userName, String password) {
                this.appendDigestParams(sb, challenge.getProperty("realm"), challenge.getProperty("nonce"), challenge.getRequestUri(), userName, password, challenge.getMethod(), challenge.getProperty("opaque"));
            }

            protected void appendDigestParams(StringBuffer sb, String realm, String nonce, String uri, String userName, String password, String method, String opaque) {
                sb.append("username=").append(this.quote(userName));
                this.append(sb, "realm", realm);
                this.append(sb, "nonce", nonce);
                this.append(sb, "uri", uri);
                this.append(sb, "response", this.getResponse(userName, realm, password, nonce, uri, method));
                this.append(sb, "opaque", opaque);
            }

            protected String getResponse(String userName, String realm, String password, String nonce, String uri, String method) {
                try {
                    String a1 = this.A1(userName, password, realm, nonce);
                    String a2 = this.A2(uri, method);
                    String ha1 = this.H(a1);
                    String ha2 = this.H(a2);
                    return this.KD(ha1, nonce + ":" + ha2);
                }
                catch (NoSuchAlgorithmException e) {
                    return "";
                }
                catch (UnsupportedEncodingException e) {
                    return "";
                }
            }

            protected String A1(String userName, String password, String realm, String nonce) throws NoSuchAlgorithmException, UnsupportedEncodingException {
                return userName + ":" + realm + ":" + password;
            }

            protected String A2(String uri, String method) {
                return method + ":" + uri;
            }

            protected final String KD(String secret, String data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
                return this.H(secret + ":" + data);
            }

            protected final String H(String data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.update(data.getBytes("UTF8"));
                byte[] bytes = digest.digest();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < bytes.length; ++i) {
                    int aByte = bytes[i];
                    if (aByte < 0) {
                        aByte += 256;
                    }
                    if (aByte < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(aByte));
                }
                return sb.toString();
            }

            private void append(StringBuffer sb, String name, String value) {
                sb.append(",").append(name).append("=").append(this.quote(value));
            }

            private String quote(String value) {
                if (value.startsWith("\"")) {
                    return value;
                }
                return "\"" + value + "\"";
            }
        }
    }

    private static class BasicAuthenticationStrategy
    implements AuthenticationStrategy {
        private BasicAuthenticationStrategy() {
        }

        @Override
        public String createAuthenticationHeader(AuthenticationChallenge challenge, String userName, String password) {
            return "Basic " + Base64.encode(userName + ":" + password);
        }
    }

    private static interface AuthenticationStrategy {
        public String createAuthenticationHeader(AuthenticationChallenge var1, String var2, String var3);
    }
}

