/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HTMLSegment;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.net.URL;
import org.w3c.dom.Node;

public abstract class BlockElement
extends ParsedHTML
implements HTMLSegment,
HTMLElement {
    private ScriptingHandler _scriptable;
    private Node _node;

    @Override
    public String getText() {
        if (this._node.getNodeType() == 3) {
            return this._node.getNodeValue().trim();
        }
        if (this._node == null || !this._node.hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(this._node.getChildNodes()).trim();
    }

    @Override
    public String getTagName() {
        return this._node == null ? "p" : this._node.getNodeName();
    }

    @Override
    public Node getDOM() {
        return super.getDOM();
    }

    @Override
    public String getID() {
        return this.getAttribute("id");
    }

    @Override
    public String getClassName() {
        return this.getAttribute("class");
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public ScriptingHandler getScriptingHandler() {
        if (this._scriptable == null) {
            this._scriptable = HttpUnitOptions.getScriptingEngine().createHandler(this);
        }
        return this._scriptable;
    }

    @Override
    public boolean doEvent(String eventScript) {
        return this.doEventScript(eventScript);
    }

    @Override
    public boolean doEventScript(String eventScript) {
        return this.getScriptingHandler().doEventScript(eventScript);
    }

    @Override
    public boolean handleEvent(String eventName) {
        return this.getScriptingHandler().handleEvent(eventName);
    }

    @Override
    public ScriptableDelegate getParentDelegate() {
        return this.getResponse().getDocumentScriptable();
    }

    @Override
    public ScriptableDelegate newScriptable() {
        return new HTMLElementScriptable(this);
    }

    @Override
    public String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this._node, name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        NodeUtils.setNodeAttribute(this._node, name, value == null ? null : value.toString());
    }

    @Override
    public void removeAttribute(String name) {
        NodeUtils.removeNodeAttribute(this._node, name);
    }

    @Override
    public boolean isSupportedAttribute(String name) {
        return false;
    }

    @Override
    public Node getNode() {
        return this._node;
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass()) && this.equals((BlockElement)obj);
    }

    private boolean equals(BlockElement block) {
        return this._node.equals(block._node);
    }

    public int hashCode() {
        return this._node.hashCode();
    }

    protected BlockElement(WebResponse response, FrameSelector frame, URL baseURL, String baseTarget, Node rootNode, String characterSet) {
        super(response, frame, baseURL, baseTarget, rootNode, characterSet);
        this._node = rootNode;
    }

    protected int getAttributeValue(Node node, String attributeName, int defaultValue) {
        return NodeUtils.getAttributeValue(node, attributeName, defaultValue);
    }
}

