/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.BooleanFormControl;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.dom.HTMLInputElementImpl;
import java.util.List;

class CheckboxFormControl
extends BooleanFormControl {
    @Override
    public String getType() {
        return "checkbox";
    }

    public CheckboxFormControl(WebForm form, HTMLInputElementImpl element) {
        super(form, element);
    }

    @Override
    protected void claimUniqueValue(List values) {
        if (this.isValueRequired()) {
            return;
        }
        this.setState(values.contains(this.getQueryValue()));
        if (this.isChecked()) {
            values.remove(this.getQueryValue());
        }
    }

    @Override
    String getQueryValue() {
        String value = this.getValueAttribute();
        return value.length() == 0 ? "on" : value;
    }

    @Override
    public void toggle() {
        this.setState(!this.isChecked());
    }

    @Override
    public void setState(boolean state) {
        boolean wasChecked = this.isChecked();
        this.setChecked(state);
        if (this.isChecked() != wasChecked) {
            this.sendOnClickEvent();
        }
    }
}

