/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.protocol.MessageBody;
import com.meterware.httpunit.protocol.ParameterCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public abstract class MessageBodyWebRequest
extends WebRequest {
    protected MessageBody _body;
    private boolean _mimeEncoded;

    protected MessageBodyWebRequest(String urlString, boolean mimeEncoded) {
        super(urlString);
        this._mimeEncoded = mimeEncoded;
    }

    protected MessageBodyWebRequest(String urlString, MessageBody messageBody) {
        super(urlString);
        this._body = messageBody;
    }

    protected MessageBodyWebRequest(URL urlBase, String urlString, String target, boolean mimeEncoded) {
        super(urlBase, urlString, target);
        this._mimeEncoded = mimeEncoded;
    }

    protected MessageBodyWebRequest(WebForm sourceForm, ParameterHolder parameterHolder, SubmitButton button, int x, int y) {
        super(sourceForm, parameterHolder, button, x, y);
        this._mimeEncoded = parameterHolder.isSubmitAsMime();
        this.setHeaderField("Referer", sourceForm.getBaseURL().toExternalForm());
    }

    protected MessageBodyWebRequest(WebForm sourceForm) {
        super(sourceForm, WebRequest.newParameterHolder(sourceForm));
        this._mimeEncoded = sourceForm.isSubmitAsMime();
        this.setHeaderField("Referer", sourceForm.getBaseURL().toExternalForm());
    }

    protected MessageBody getMessageBody() {
        return this._body;
    }

    @Override
    protected void writeMessageBody(OutputStream stream) throws IOException {
        this.getMessageBody().writeTo(stream, this.getParameterHolder());
    }

    @Override
    protected void completeRequest(URLConnection connection) throws IOException {
        super.completeRequest(connection);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        OutputStream stream = connection.getOutputStream();
        this.writeMessageBody(stream);
        stream.flush();
        stream.close();
    }

    @Override
    protected String getContentType() {
        return this.getMessageBody().getContentType();
    }

    @Override
    public boolean isMimeEncoded() {
        return this._mimeEncoded;
    }

    public static class InputStreamMessageBody
    extends MessageBody {
        private InputStream _source;
        private String _contentType;

        public InputStreamMessageBody(InputStream source, String contentType) {
            super(null);
            this._source = source;
            this._contentType = contentType;
        }

        @Override
        public String getContentType() {
            return this._contentType;
        }

        @Override
        public void writeTo(OutputStream outputStream, ParameterCollection parameters) throws IOException {
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                outputStream.write(buffer, 0, count);
            } while ((count = this._source.read(buffer, 0, buffer.length)) != -1);
            this._source.close();
        }
    }
}

