/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.MessageBodyWebRequest;
import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.protocol.MessageBody;
import com.meterware.httpunit.protocol.URLEncodedString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PostMethodWebRequest
extends MessageBodyWebRequest {
    public PostMethodWebRequest(String urlString) {
        this(urlString, false);
    }

    public PostMethodWebRequest(String urlString, boolean mimeEncoded) {
        super(urlString, mimeEncoded);
    }

    public PostMethodWebRequest(URL urlBase, String urlString, String target) {
        this(urlBase, urlString, target, false);
    }

    public PostMethodWebRequest(URL urlBase, String urlString, String target, boolean mimeEncoded) {
        super(urlBase, urlString, target, mimeEncoded);
    }

    public PostMethodWebRequest(String urlString, InputStream source, String contentType) {
        super(urlString, false);
        this._body = new MessageBodyWebRequest.InputStreamMessageBody(source, contentType);
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public String getQueryString() {
        try {
            URLEncodedString encoder = new URLEncodedString();
            this.getParameterHolder().recordPredefinedParameters(encoder);
            return encoder.getString();
        }
        catch (IOException e) {
            throw new RuntimeException("Programming error: " + e);
        }
    }

    @Override
    protected boolean maySelectFile(String parameterName) {
        return this.isMimeEncoded() && this.isFileParameter(parameterName);
    }

    @Override
    protected MessageBody getMessageBody() {
        if (this._body == null) {
            this._body = MessageBody.createPostMethodMessageBody(this.isMimeEncoded(), this.getCharacterSet());
        }
        return this._body;
    }

    PostMethodWebRequest(WebForm sourceForm, SubmitButton button, int x, int y) {
        this(sourceForm, sourceForm, button, x, y);
    }

    PostMethodWebRequest(WebForm sourceForm, ParameterHolder parameterHolder, SubmitButton button, int x, int y) {
        super(sourceForm, parameterHolder, button, x, y);
    }

    PostMethodWebRequest(WebForm sourceForm) {
        super(sourceForm);
    }
}

