/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.ElementRegistry;
import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.FormParameter;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.IllegalRequestParameterException;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PresetFormParameter;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UncheckedParameterHolder;
import com.meterware.httpunit.UnsupportedActionException;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebRequestSource;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.protocol.UploadFileSpec;
import com.meterware.httpunit.scripting.FormScriptable;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFormElement;
import org.xml.sax.SAXException;

public class WebForm
extends WebRequestSource {
    private static final FormParameter UNKNOWN_PARAMETER = new FormParameter();
    private static final String[] NO_VALUES = new String[0];
    private Button[] _buttons;
    private SubmitButton[] _submitButtons;
    private String _characterSet;
    private Vector _buttonVector;
    private FormControl[] _presetParameters;
    private ArrayList _presets;
    private ElementRegistry _registry;
    public static final HTMLElementPredicate MATCH_NAME = new HTMLElementPredicate(){

        @Override
        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.matches(((WebForm)htmlElement).getName(), (String)criteria);
        }
    };
    private HTMLFormElement _domElement;

    public WebResponse submit() throws IOException, SAXException {
        return this.submit(this.getDefaultButton());
    }

    public WebResponse submit(SubmitButton button) throws IOException, SAXException {
        WebResponse result = this.submit(button, 0, 0);
        return result;
    }

    public WebResponse submit(SubmitButton button, int x, int y) throws IOException, SAXException {
        WebResponse result = null;
        result = button == null || button.doOnClickSequence(x, y) ? this.doFormSubmit(button, x, y) : this.getCurrentFrameContents();
        return result;
    }

    public WebResponse submitNoButton() throws SAXException, IOException {
        return this.submit(SubmitButton.createFakeSubmitButton(this));
    }

    @Override
    protected WebResponse submitRequest(String event, WebRequest request) throws IOException, SAXException {
        try {
            return super.submitRequest(event, request);
        }
        catch (UnknownServiceException e) {
            throw new UnsupportedActionException("HttpUnit does not support " + request.getURL().getProtocol() + " URLs in form submissions");
        }
    }

    WebResponse doFormSubmit(SubmitButton button) throws IOException, SAXException {
        return this.submitRequest(this.getAttribute("onsubmit"), this.getRequest(button));
    }

    WebResponse doFormSubmit(SubmitButton button, int x, int y) throws IOException, SAXException {
        return this.submitRequest(this.getAttribute("onsubmit"), this.getRequest(button, x, y));
    }

    public String getMethod() {
        return this.getAttribute("method", "GET");
    }

    public String getAction() {
        return this.getDestination();
    }

    public boolean hasParameterNamed(String soughtName) {
        return this.getFormParameters().containsKey(soughtName);
    }

    public boolean hasParameterStartingWithPrefix(String prefix) {
        String[] names = this.getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Button[] getButtons() {
        if (this._buttons == null) {
            FormControl[] controls = this.getFormControls();
            ArrayList<FormControl> buttonList = new ArrayList<FormControl>();
            for (int i = 0; i < controls.length; ++i) {
                FormControl control = controls[i];
                if (!(control instanceof Button)) continue;
                buttonList.add(control);
            }
            this._buttons = buttonList.toArray(new Button[buttonList.size()]);
        }
        return this._buttons;
    }

    public Button getButton(HTMLElementPredicate predicate, Object criteria) {
        Button[] buttons = this.getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!predicate.matchesCriteria(buttons[i], criteria)) continue;
            return buttons[i];
        }
        return null;
    }

    public Button getButtonWithID(String buttonID) {
        return this.getButton(Button.WITH_ID, buttonID);
    }

    public SubmitButton[] getSubmitButtons() {
        if (this._submitButtons == null) {
            Vector buttons = this.getSubmitButtonVector();
            this._submitButtons = new SubmitButton[buttons.size()];
            buttons.copyInto(this._submitButtons);
        }
        return this._submitButtons;
    }

    public SubmitButton getSubmitButton(String name) {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getName().equals(name)) continue;
            return buttons[i];
        }
        return null;
    }

    public SubmitButton getSubmitButton(String name, String value) {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getName().equals(name) || !buttons[i].getValue().equals(value)) continue;
            return buttons[i];
        }
        return null;
    }

    public SubmitButton getSubmitButtonWithID(String ID) {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getID().equals(ID)) continue;
            return buttons[i];
        }
        return null;
    }

    public WebRequest getRequest(String submitButtonName, String submitButtonValue) {
        SubmitButton sb = this.getSubmitButton(submitButtonName, submitButtonValue);
        if (sb == null) {
            throw new IllegalSubmitButtonException(submitButtonName, submitButtonValue);
        }
        return this.getRequest(sb);
    }

    public WebRequest getRequest(String submitButtonName) {
        SubmitButton sb = this.getSubmitButton(submitButtonName);
        if (sb == null) {
            throw new IllegalSubmitButtonException(submitButtonName, "");
        }
        return this.getRequest(sb);
    }

    public WebRequest getRequest(SubmitButton button) {
        return this.getRequest(button, 0, 0);
    }

    public WebRequest getRequest(SubmitButton button, int x, int y) {
        if (button == null) {
            button = this.getDefaultButton();
        }
        if (HttpUnitOptions.getParameterValuesValidated()) {
            if (button == null) {
                throw new IllegalUnnamedSubmitButtonException();
            }
            if (!button.isFake()) {
                if (!this.getSubmitButtonVector().contains(button)) {
                    throw new IllegalSubmitButtonException(button);
                }
                if (!button.wasEnabled()) {
                    button.throwDisabledException();
                }
            }
        }
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPressed(false);
        }
        button.setPressed(true);
        if (this.getMethod().equalsIgnoreCase("post")) {
            return new PostMethodWebRequest(this, button, x, y);
        }
        return new GetMethodWebRequest(this, WebRequest.newParameterHolder(this), button, x, y);
    }

    public WebRequest newUnvalidatedRequest(SubmitButton button) {
        return this.newUnvalidatedRequest(button, 0, 0);
    }

    public WebRequest newUnvalidatedRequest(SubmitButton button, int x, int y) {
        if (button == null) {
            button = this.getDefaultButton();
        }
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPressed(false);
        }
        button.setPressed(true);
        if (this.getMethod().equalsIgnoreCase("post")) {
            return new PostMethodWebRequest(this, new UncheckedParameterHolder(this), button, x, y);
        }
        return new GetMethodWebRequest(this, new UncheckedParameterHolder(this), button, x, y);
    }

    private WebRequest getScriptedSubmitRequest() {
        SubmitButton[] buttons = this.getSubmitButtons();
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPressed(false);
        }
        if (this.getMethod().equalsIgnoreCase("post")) {
            return new PostMethodWebRequest(this);
        }
        return new GetMethodWebRequest(this);
    }

    public String getParameterValue(String name) {
        String[] values = this.getParameterValues(name);
        return values.length == 0 ? null : values[0];
    }

    public String[] getOptions(String name) {
        return this.getParameter(name).getOptions();
    }

    public String[] getOptionValues(String name) {
        return this.getParameter(name).getOptionValues();
    }

    public boolean isMultiValuedParameter(String name) {
        return this.getParameter(name).isMultiValuedParameter();
    }

    public int getNumTextParameters(String name) {
        return this.getParameter(name).getNumTextParameters();
    }

    public boolean isTextParameter(String name) {
        return this.getParameter(name).isTextParameter();
    }

    @Override
    public boolean isSubmitAsMime() {
        return "multipart/form-data".equalsIgnoreCase(this.getAttribute("enctype"));
    }

    public FormScriptable getScriptableObject() {
        return (FormScriptable)((Object)this.getScriptingHandler());
    }

    public void reset() {
        if (this.handleEvent("onreset")) {
            this.resetControls();
        }
    }

    private void resetControls() {
        FormControl[] controls = this.getFormControls();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].reset();
        }
    }

    @Override
    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    @Override
    public String getCharacterSet() {
        return this._characterSet;
    }

    @Override
    public boolean isFileParameter(String name) {
        return this.getParameter(name).isFileParameter();
    }

    @Override
    public String[] getParameterNames() {
        ArrayList parameterNames = new ArrayList(this.getFormParameters().keySet());
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    @Override
    public String[] getParameterValues(String name) {
        FormParameter parameter = this.getParameter(name);
        return parameter.getValues();
    }

    public boolean isReadOnlyParameter(String name) {
        return this.getParameter(name).isReadOnlyParameter();
    }

    public boolean isDisabledParameter(String name) {
        return this.getParameter(name).isDisabledParameter();
    }

    public boolean isHiddenParameter(String name) {
        return this.getParameter(name).isHiddenParameter();
    }

    @Override
    public WebRequest getRequest() {
        return this.getRequest((SubmitButton)null);
    }

    public WebRequest newUnvalidatedRequest() {
        return this.newUnvalidatedRequest(null);
    }

    @Override
    protected void addPresetParameter(String name, String value) {
        FormControl[] formControls = this.getFormControls();
        for (int i = 0; i < formControls.length; ++i) {
            if (!formControls[i].getName().equals(name)) continue;
            return;
        }
        this._presets.add(new PresetFormParameter(this, name, value));
    }

    @Override
    protected String getEmptyParameterValue() {
        return null;
    }

    @Override
    void selectImageButtonPosition(SubmitButton imageButton, int x, int y) {
        imageButton.setLocation(x, y);
    }

    @Override
    void recordPredefinedParameters(ParameterProcessor processor) throws IOException {
        FormControl[] controls = this.getPresetParameters();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].addValues(processor, this.getCharacterSet());
        }
    }

    @Override
    public void recordParameters(ParameterProcessor processor) throws IOException {
        FormControl[] controls = this.getFormControls();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].addValues(processor, this.getCharacterSet());
        }
    }

    @Override
    public void removeParameter(String name) {
        this.setParameter(name, NO_VALUES);
    }

    @Override
    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    @Override
    public void setParameter(String name, String[] values) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == UNKNOWN_PARAMETER) {
            throw new NoSuchParameterException(name);
        }
        if (parameter.isFileParameter()) {
            throw new InvalidFileParameterException(name, values);
        }
        parameter.setValues(values);
    }

    @Override
    public void setParameter(String name, UploadFileSpec[] files) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null || !parameter.isFileParameter()) {
            throw new NoSuchParameterException(name);
        }
        parameter.setFiles(files);
    }

    public void setParameter(String name, File file) {
        this.setParameter(name, new UploadFileSpec[]{new UploadFileSpec(file)});
    }

    public void toggleCheckbox(String name) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.toggleCheckbox();
    }

    public void toggleCheckbox(String name, String value) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.toggleCheckbox(value);
    }

    public void setCheckbox(String name, boolean state) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.setValue(state);
    }

    public void setCheckbox(String name, String value, boolean state) {
        FormParameter parameter = this.getParameter(name);
        if (parameter == null) {
            throw new NoSuchParameterException(name);
        }
        parameter.setValue(value, state);
    }

    WebForm(WebResponse response, URL baseURL, Node node, FrameSelector frame, String defaultTarget, String characterSet, ElementRegistry registry) {
        super(response, node, baseURL, "action", frame, defaultTarget);
        this._characterSet = characterSet;
        this._registry = registry;
        this._domElement = (HTMLFormElement)node;
    }

    public FormControl getControlWithID(String id) {
        FormControl[] controls = this.getFormControls();
        for (int i = 0; i < controls.length; ++i) {
            FormControl control = controls[i];
            if (!control.getID().equals(id)) continue;
            return control;
        }
        return null;
    }

    private SubmitButton getDefaultButton() {
        if (this.getSubmitButtons().length == 1) {
            return this.getSubmitButtons()[0];
        }
        return this.getSubmitButton("");
    }

    private Vector getSubmitButtonVector() {
        if (this._buttonVector == null) {
            this._buttonVector = new Vector();
            FormControl[] controls = this.getFormControls();
            for (int i = 0; i < controls.length; ++i) {
                FormControl control = controls[i];
                if (!(control instanceof SubmitButton)) continue;
                SubmitButton sb = (SubmitButton)control;
                sb.rememberEnableState();
                this._buttonVector.add(sb);
            }
            if (this._buttonVector.isEmpty()) {
                this._buttonVector.addElement(SubmitButton.createFakeSubmitButton(this));
            }
        }
        return this._buttonVector;
    }

    private FormControl[] getPresetParameters() {
        if (this._presetParameters == null) {
            this._presets = new ArrayList();
            this.loadDestinationParameters();
            this._presetParameters = this._presets.toArray(new FormControl[this._presets.size()]);
        }
        return this._presetParameters;
    }

    FormControl newFormControl(Node child) {
        return FormControl.newFormParameter(this, child);
    }

    private FormControl[] getFormControls() {
        HTMLCollection controlElements = this._domElement.getElements();
        FormControl[] controls = new FormControl[controlElements.getLength()];
        for (int i = 0; i < controls.length; ++i) {
            controls[i] = this.getControlForNode(controlElements.item(i));
        }
        return controls;
    }

    private FormControl getControlForNode(Node node) {
        if (this._registry.hasNode(node)) {
            return (FormControl)this._registry.getRegisteredElement(node);
        }
        return (FormControl)this._registry.registerElement(node, this.newFormControl(node));
    }

    public FormParameter getParameter(String name) {
        FormParameter parameter = (FormParameter)this.getFormParameters().get(name);
        return parameter != null ? parameter : UNKNOWN_PARAMETER;
    }

    private Map getFormParameters() {
        HashMap formParameters = new HashMap();
        this.loadFormParameters(formParameters, this.getPresetParameters());
        this.loadFormParameters(formParameters, this.getFormControls());
        return formParameters;
    }

    private void loadFormParameters(Map formParameters, FormControl[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            if (controls[i].getName().length() == 0) continue;
            FormParameter parameter = (FormParameter)formParameters.get(controls[i].getName());
            if (parameter == null) {
                parameter = new FormParameter();
                formParameters.put(controls[i].getName(), parameter);
            }
            parameter.addControl(controls[i]);
        }
    }

    class IllegalSubmitButtonException
    extends IllegalRequestParameterException {
        private String _name;
        private String _value;

        IllegalSubmitButtonException(SubmitButton button) {
            this._name = button.getName();
            this._value = button.getValue();
        }

        IllegalSubmitButtonException(String name, String value) {
            this._name = name;
            this._value = value;
        }

        @Override
        public String getMessage() {
            return "Specified submit button (name=\"" + this._name + "\" value=\"" + this._value + "\") not part of this form.";
        }
    }

    class IllegalUnnamedSubmitButtonException
    extends IllegalRequestParameterException {
        IllegalUnnamedSubmitButtonException() {
        }

        @Override
        public String getMessage() {
            return "This form has more than one submit button, none unnamed. You must specify the button to be used.";
        }
    }

    class NoSuchParameterException
    extends IllegalRequestParameterException {
        private String _parameterName;

        NoSuchParameterException(String parameterName) {
            this._parameterName = parameterName;
        }

        @Override
        public String getMessage() {
            return "No parameter named '" + this._parameterName + "' is defined in the form";
        }
    }

    class InvalidFileParameterException
    extends IllegalRequestParameterException {
        private String _parameterName;
        private String[] _values;

        InvalidFileParameterException(String parameterName, String[] values) {
            this._parameterName = parameterName;
            this._values = values;
        }

        @Override
        public String getMessage() {
            Object valueList = "";
            String delim = "";
            for (int i = 0; i < this._values.length; ++i) {
                valueList = (String)valueList + delim + "'" + this._values[i] + "'";
                delim = ", ";
            }
            String msg = "The file parameter with the name '" + this._parameterName + "' must have type File but the string values " + (String)valueList + " where supplied";
            return msg;
        }
    }

    public class Scriptable
    extends HTMLElementScriptable
    implements NamedDelegate,
    FormScriptable {
        public String getAction() {
            return WebForm.this.getAction();
        }

        @Override
        public void setAction(String newAction) {
            WebForm.this.setDestination(newAction);
            WebForm.this._presetParameters = null;
        }

        public void submit() throws IOException, SAXException {
            WebForm.this.submitRequest(WebForm.this.getScriptedSubmitRequest());
        }

        public void reset() throws IOException, SAXException {
            WebForm.this.resetControls();
        }

        @Override
        public String getName() {
            return WebForm.this.getID().length() != 0 ? WebForm.this.getID() : WebForm.this.getName();
        }

        @Override
        public Object get(String propertyName) {
            if (propertyName.equals("target")) {
                return WebForm.this.getTarget();
            }
            if (propertyName.equals("action")) {
                return this.getAction();
            }
            if (propertyName.equals("length")) {
                return new Integer(WebForm.this.getFormControls().length);
            }
            FormParameter parameter = WebForm.this.getParameter(propertyName);
            if (parameter != UNKNOWN_PARAMETER) {
                return parameter.getScriptableObject();
            }
            FormControl control = WebForm.this.getControlWithID(propertyName);
            return control == null ? super.get(propertyName) : control.getScriptingHandler();
        }

        @Override
        public void set(String propertyName, Object value) {
            if (propertyName.equals("target")) {
                WebForm.this.setTargetAttribute(value.toString());
            } else if (propertyName.equals("action")) {
                this.setAction(value.toString());
            } else if (value instanceof String) {
                this.setParameterValue(propertyName, (String)value);
            } else if (value instanceof Number) {
                this.setParameterValue(propertyName, HttpUnitUtils.trimmedValue((Number)value));
            } else {
                super.set(propertyName, value);
            }
        }

        @Override
        public void setParameterValue(String name, String value) {
            Object scriptableObject = WebForm.this.getParameter(name).getScriptableObject();
            if (scriptableObject instanceof ScriptableDelegate) {
                ((ScriptableDelegate)scriptableObject).set("value", value);
            } else if (scriptableObject instanceof ScriptableDelegate[]) {
                ((ScriptableDelegate[])scriptableObject)[0].set("value", value);
            }
        }

        public ScriptableDelegate[] getElementDelegates() {
            FormControl[] controls = WebForm.this.getFormControls();
            ScriptableDelegate[] result = new ScriptableDelegate[controls.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (ScriptableDelegate)controls[i].getScriptingHandler();
            }
            return result;
        }

        public ScriptableDelegate[] getElementsByTagName(String name) throws SAXException {
            return this.getDelegates(WebForm.this.getHTMLPage().getElementsByTagName(WebForm.this.getElement(), name));
        }

        Scriptable() {
            super(WebForm.this);
        }
    }
}

