/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameHolder;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.net.URL;
import org.w3c.dom.Node;

class WebFrame
extends HTMLElementBase {
    private FrameSelector _selector;
    private WebResponse _response;
    private Node _element;
    private URL _baseURL;

    @Override
    public ScriptableDelegate getParentDelegate() {
        return this._response.getDocumentScriptable();
    }

    WebFrame(WebResponse response, URL baseURL, Node frameNode, FrameSelector parentFrame) {
        super(frameNode);
        this._response = response;
        this._element = frameNode;
        this._baseURL = baseURL;
        this._selector = this.getFrameSelector(parentFrame);
    }

    String getFrameName() {
        return this._selector.getName();
    }

    FrameSelector getSelector() {
        return this._selector;
    }

    private FrameSelector getFrameSelector(FrameSelector parentFrame) {
        return FrameHolder.newNestedFrame(parentFrame, super.getName());
    }

    WebRequest getInitialRequest() {
        return new GetMethodWebRequest(this._baseURL, HttpUnitUtils.trimFragment(NodeUtils.getNodeAttribute(this._element, "src")), this._selector);
    }

    boolean hasInitialRequest() {
        return NodeUtils.getNodeAttribute(this._element, "src").length() > 0;
    }
}

