/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.TextBlock;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.net.URL;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class WebList
extends HTMLElementBase {
    public static final int ORDERED_LIST = 1;
    public static final int BULLET_LIST = 2;
    private WebResponse _response;
    private FrameSelector _frame;
    private URL _baseURL;
    private String _baseTarget;
    private String _characterSet;
    private ArrayList _items = new ArrayList();
    private int _listType;

    public WebList(WebResponse response, FrameSelector frame, URL baseURL, String baseTarget, Element element, String characterSet) {
        super(element);
        if (element.getNodeName().equalsIgnoreCase("ol")) {
            this._listType = 1;
        } else if (element.getNodeName().equalsIgnoreCase("ul")) {
            this._listType = 2;
        }
        this._response = response;
        this._frame = frame;
        this._baseURL = baseURL;
        this._baseTarget = baseTarget;
        this._characterSet = characterSet;
    }

    public int getListType() {
        return this._listType;
    }

    public TextBlock[] getItems() {
        return this._items.toArray(new TextBlock[this._items.size()]);
    }

    @Override
    public ScriptableDelegate newScriptable() {
        return new HTMLElementScriptable(this);
    }

    @Override
    public ScriptableDelegate getParentDelegate() {
        return this._response.getDocumentScriptable();
    }

    TextBlock addNewItem(Element element) {
        TextBlock listItem = new TextBlock(this._response, this._frame, this._baseURL, this._baseTarget, element, this._characterSet);
        this._items.add(listItem);
        return listItem;
    }
}

