/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.DefaultWebResponse;
import com.meterware.httpunit.FrameHolder;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NoSuchFrameException;
import com.meterware.httpunit.RecursiveRedirectionException;
import com.meterware.httpunit.RedirectWebRequest;
import com.meterware.httpunit.RequestContext;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.SAXException;

public class WebWindow {
    private WebClient _client;
    private FrameHolder _frameContents;
    private String _name = "";
    private WebResponse _opener;
    private boolean _closed;
    static final String NO_NAME = "$$HttpUnit_Window$$_";
    private final Set _redirects;
    private boolean _isInitialRequest = true;
    private WebRequest _initialRequest;

    public WebClient getClient() {
        return this._client;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void close() {
        if (!this._closed) {
            this._client.close(this);
        }
        this._closed = true;
    }

    public String getName() {
        return this._name;
    }

    public WebResponse getOpener() {
        return this._opener;
    }

    public WebResponse getResponse(String urlString) throws IOException, SAXException {
        return this.getResponse(new GetMethodWebRequest(urlString));
    }

    public WebResponse sendRequest(WebRequest request) throws IOException, SAXException {
        return this.getResponse(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebResponse getResponse(WebRequest request) throws IOException, SAXException {
        if (this._isInitialRequest) {
            this._initialRequest = request;
            this._isInitialRequest = false;
        }
        WebResponse result = null;
        try {
            RequestContext requestContext = new RequestContext();
            WebResponse response = this.getSubframeResponse(request, requestContext);
            requestContext.runScripts();
            result = response == null ? null : response.getWindow().getFrameContents(response.getFrame());
        }
        finally {
            if (null != request && request.equals(this._initialRequest)) {
                this._redirects.clear();
                this._initialRequest = null;
                this._isInitialRequest = true;
            }
        }
        return result;
    }

    WebResponse getSubframeResponse(WebRequest request, RequestContext requestContext) throws IOException, SAXException {
        WebResponse response = this.getResource(request);
        return response == null ? null : this.updateWindow(request.getTarget(), response, requestContext);
    }

    WebResponse updateWindow(String requestTarget, WebResponse response, RequestContext requestContext) throws IOException, SAXException {
        this._client.updateClient(response);
        if (this.getClient().getClientProperties().isAutoRefresh() && response.getRefreshRequest() != null) {
            WebRequest request = response.getRefreshRequest();
            WebResponse result = this.getResponse(request);
            return result;
        }
        if (this.shouldFollowRedirect(response)) {
            this.delay(HttpUnitOptions.getRedirectDelay());
            return this.getResponse(new RedirectWebRequest(response));
        }
        this._client.updateFrameContents(this, requestTarget, response, requestContext);
        return response;
    }

    public WebResponse getResource(WebRequest request) throws IOException {
        this._client.tellListeners(request);
        WebResponse response = null;
        String urlString = request.getURLString().trim();
        FrameSelector targetFrame = this._frameContents.getTargetFrame(request);
        if (urlString.startsWith("about:")) {
            response = new DefaultWebResponse(this._client, targetFrame, null, "");
        } else if (!HttpUnitUtils.isJavaScriptURL(urlString)) {
            response = this._client.createResponse(request, targetFrame);
        } else {
            Object result;
            ScriptingHandler handler = request.getSourceScriptingHandler();
            if (handler == null) {
                handler = this.getCurrentPage().getScriptingHandler();
            }
            if ((result = handler.evaluateExpression(urlString)) != null) {
                response = new DefaultWebResponse(this._client, targetFrame, request.getURL(), result.toString());
            }
        }
        if (response != null) {
            this._client.tellListeners(response);
        }
        return response;
    }

    public String[] getFrameNames() {
        List names = this._frameContents.getActiveFrameNames();
        return names.toArray(new String[names.size()]);
    }

    public boolean hasFrame(String frameName) {
        return this._frameContents.get(frameName) != null;
    }

    boolean hasFrame(FrameSelector frame) {
        return this._frameContents.get(frame) != null;
    }

    public WebResponse getFrameContents(String frameName) {
        WebResponse response = this._frameContents.get(frameName);
        if (response == null) {
            throw new NoSuchFrameException(frameName);
        }
        return response;
    }

    WebResponse getFrameContents(FrameSelector targetFrame) {
        return this._frameContents.getFrameContents(targetFrame);
    }

    WebResponse getSubframeContents(FrameSelector frame, String subFrameName) {
        return this._frameContents.getSubframeContents(frame, subFrameName);
    }

    WebResponse getParentFrameContents(FrameSelector frame) {
        return this._frameContents.getParentFrameContents(frame);
    }

    public WebResponse getCurrentPage() {
        return this.getFrameContents("_top");
    }

    WebWindow(WebClient client) {
        this._client = client;
        this._frameContents = new FrameHolder(this);
        this._name = NO_NAME + this._client.getOpenWindows().length;
        this._redirects = new HashSet();
    }

    WebWindow(WebClient client, WebResponse opener) {
        this(client);
        this._opener = opener;
    }

    void updateFrameContents(WebResponse response, RequestContext requestContext) throws IOException, SAXException {
        response.setWindow(this);
        this._frameContents.updateFrames(response, response.getFrame(), requestContext);
    }

    void setName(String name) {
        this._name = name;
    }

    private void delay(int numMilliseconds) {
        if (numMilliseconds == 0) {
            return;
        }
        try {
            Thread.sleep(numMilliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean redirectConfigured(WebResponse response) {
        boolean isAutoredirect = this.getClient().getClientProperties().isAutoRedirect();
        boolean hasLocation = response.getHeaderField("Location") != null;
        int responseCode = response.getResponseCode();
        boolean result = isAutoredirect && responseCode >= 301 && responseCode <= 302 && hasLocation;
        return result;
    }

    private boolean shouldFollowRedirect(WebResponse response) {
        if (!this.redirectConfigured(response)) {
            return false;
        }
        String redirectLocation = response.getHeaderField("Location");
        URL url = null;
        try {
            if (redirectLocation != null) {
                url = new URL(response.getURL(), redirectLocation);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        switch (response.getResponseCode()) {
            case 301: 
            case 302: {
                if (null != url && this._redirects.contains(url)) {
                    throw new RecursiveRedirectionException(url, "Unable to process request due to redirection loop");
                }
                this._redirects.add(url);
            }
        }
        return redirectLocation != null;
    }

    FrameSelector getTopFrame() {
        return this._frameContents.getTopFrame();
    }

    FrameSelector getFrame(String target) {
        return this._frameContents.getFrame(target);
    }
}

