/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.DocumentImpl;
import com.meterware.httpunit.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class AttrImpl
extends NodeImpl
implements Attr {
    private String _name;
    private String _value = "";
    private boolean _specified = false;
    private Element _ownerElement;

    static AttrImpl createAttribute(DocumentImpl owner, String name) {
        AttrImpl attribute = new AttrImpl();
        attribute.initialize(owner, name);
        return attribute;
    }

    public static Attr createAttribute(DocumentImpl owner, String namespaceURI, String qualifiedName) {
        AttrImpl attribute = new AttrImpl();
        attribute.initialize(owner, qualifiedName);
        return attribute;
    }

    protected void initialize(DocumentImpl owner, String name) {
        super.initialize(owner);
        this._name = name;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.setValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean getSpecified() {
        return this._specified;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public void setValue(String value) throws DOMException {
        this._value = value;
        this._specified = true;
    }

    @Override
    public Element getOwnerElement() {
        return this._ownerElement;
    }

    void setOwnerElement(Element ownerElement) {
        this._ownerElement = ownerElement;
    }

    public static Node importNode(Document document, Attr attr) {
        Attr attribute = document.createAttributeNS(attr.getNamespaceURI(), attr.getName());
        attribute.setValue(attr.getValue());
        return attribute;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return false;
    }
}

