/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.dom.DomWindow;
import com.meterware.httpunit.dom.HTMLBodyElementImpl;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.javascript.JavaScript;
import com.meterware.httpunit.javascript.ScriptingEngineImpl;
import com.meterware.httpunit.scripting.ScriptingEngineFactory;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.util.logging.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.html.HTMLDocument;

public class DomBasedScriptingEngineFactory
implements ScriptingEngineFactory {
    @Override
    public boolean isEnabled() {
        try {
            Class.forName("org.mozilla.javascript.Context");
            return true;
        }
        catch (Exception e) {
            Logger.getLogger("httpunit.org").warning("Rhino classes (js.jar) not found - Javascript disabled");
            return false;
        }
    }

    @Override
    public void associate(WebResponse response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(WebResponse response) {
        Object onLoadEvent = null;
        try {
            Context context = Context.enter();
            context.initStandardObjects(null);
            HTMLDocument htmlDocument = ((DomWindow)response.getScriptingHandler()).getDocument();
            if (!(htmlDocument instanceof HTMLDocumentImpl)) {
                return;
            }
            HTMLBodyElementImpl body = (HTMLBodyElementImpl)htmlDocument.getBody();
            if (body == null) {
                return;
            }
            onLoadEvent = body.getOnloadEvent();
            if (onLoadEvent == null) {
                return;
            }
            onLoadEvent.call(context, (Scriptable)body, (Scriptable)body, new Object[0]);
        }
        catch (JavaScriptException e) {
            ScriptingEngineImpl.handleScriptException((Exception)((Object)e), onLoadEvent.toString());
        }
        catch (EcmaError ee) {
            ScriptingEngineImpl.handleScriptException((Exception)((Object)ee), onLoadEvent.toString());
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public void setThrowExceptionsOnError(boolean throwExceptions) {
        JavaScript.setThrowExceptionsOnError(throwExceptions);
    }

    @Override
    public boolean isThrowExceptionsOnError() {
        return JavaScript.isThrowExceptionsOnError();
    }

    @Override
    public String[] getErrorMessages() {
        return ScriptingEngineImpl.getErrorMessages();
    }

    @Override
    public void clearErrorMessages() {
        ScriptingEngineImpl.clearErrorMessages();
    }

    @Override
    public ScriptingHandler createHandler(HTMLElement elementBase) {
        return (ScriptingHandler)((Object)elementBase.getNode());
    }

    @Override
    public ScriptingHandler createHandler(WebResponse response) {
        return response.createDomScriptingHandler();
    }
}

