/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLSelectElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import java.io.IOException;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLOptionElement;

public class HTMLOptionElementImpl
extends HTMLControl
implements HTMLOptionElement {
    private Boolean _selected;

    @Override
    ElementImpl create() {
        return new HTMLOptionElementImpl();
    }

    @Override
    public boolean getDefaultSelected() {
        return this.getBooleanAttribute("selected");
    }

    @Override
    public int getIndex() {
        return this.getSelect().getIndexOf(this);
    }

    public void setIndex(int i) {
    }

    @Override
    public String getLabel() {
        return this.getAttributeWithNoDefault("label");
    }

    @Override
    public boolean getSelected() {
        return this._selected != null ? this._selected.booleanValue() : this.getDefaultSelected();
    }

    @Override
    public String getText() {
        return this.asText();
    }

    @Override
    public void setDefaultSelected(boolean defaultSelected) {
    }

    @Override
    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected && this.getSelect().getType().equals("select-one")) {
            this.getSelect().clearSelected();
        }
        this._selected = selected ? Boolean.TRUE : Boolean.FALSE;
    }

    private HTMLSelectElementImpl getSelect() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && !"select".equalsIgnoreCase(parent.getNodeName()); parent = parent.getParentNode()) {
        }
        return (HTMLSelectElementImpl)parent;
    }

    @Override
    public String getValue() {
        return this.getAttributeWithNoDefault("value");
    }

    @Override
    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    @Override
    public void reset() {
        this._selected = null;
    }

    void addValueIfSelected(ParameterProcessor processor, String name, String characterSet) throws IOException {
        if (this.getSelected()) {
            String value = this.getValue();
            if (value == null) {
                value = this.readDisplayedValue();
            }
            processor.addParameter(name, value, characterSet);
        }
    }

    private String readDisplayedValue() {
        Node nextSibling;
        for (nextSibling = this.getNextSibling(); nextSibling != null && nextSibling.getNodeType() != 3 && nextSibling.getNodeType() != 1; nextSibling = nextSibling.getNextSibling()) {
        }
        if (nextSibling == null || nextSibling.getNodeType() != 3) {
            return "";
        }
        return nextSibling.getNodeValue();
    }
}

