/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLCollectionImpl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLOptionElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

public class HTMLSelectElementImpl
extends HTMLControl
implements HTMLSelectElement {
    public static final String TYPE_SELECT_ONE = "select-one";
    public static final String TYPE_SELECT_MULTIPLE = "select-multiple";

    @Override
    ElementImpl create() {
        return new HTMLSelectElementImpl();
    }

    @Override
    public void add(HTMLElement element, HTMLElement before) throws DOMException {
    }

    @Override
    public void blur() {
        this.handleEvent("onblur");
    }

    @Override
    public void focus() {
        this.handleEvent("onfocus");
    }

    @Override
    public String getType() {
        return this.isMultiSelect() ? TYPE_SELECT_MULTIPLE : TYPE_SELECT_ONE;
    }

    private boolean isMultiSelect() {
        return this.getMultiple() && this.getSize() > 1;
    }

    @Override
    public int getLength() {
        return this.getOptions().getLength();
    }

    @Override
    public boolean getMultiple() {
        return this.getBooleanAttribute("multiple");
    }

    @Override
    public HTMLCollection getOptions() {
        return HTMLCollectionImpl.createHTMLCollectionImpl(this.getElementsByTagName(this.getHtmlDocument().toNodeCase("option")));
    }

    @Override
    public int getSelectedIndex() {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            if (!((HTMLOptionElement)options.item(i)).getSelected()) continue;
            return i;
        }
        return this.isMultiSelect() ? -1 : 0;
    }

    @Override
    public String getValue() {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            HTMLOptionElement optionElement = (HTMLOptionElement)options.item(i);
            if (!optionElement.getSelected()) continue;
            return optionElement.getValue();
        }
        return this.isMultiSelect() || options.getLength() == 0 ? null : ((HTMLOptionElement)options.item(0)).getValue();
    }

    @Override
    public int getSize() {
        return this.getIntegerAttribute("size");
    }

    @Override
    public void remove(int index) {
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.setAttribute("multiple", multiple);
    }

    @Override
    public void setSelectedIndex(int selectedIndex) {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            HTMLOptionElementImpl optionElement = (HTMLOptionElementImpl)options.item(i);
            optionElement.setSelected(i == selectedIndex);
        }
    }

    @Override
    public void setSize(int size) {
        this.setAttribute("size", size);
    }

    int getIndexOf(HTMLOptionElementImpl option) {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            if (options.item(i) != option) continue;
            return i;
        }
        throw new IllegalStateException("option is not part of this select");
    }

    void clearSelected() {
        this.setSelectedIndex(-1);
    }

    @Override
    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        HTMLCollection options = this.getOptions();
        String name = this.getName();
        for (int i = 0; i < options.getLength(); ++i) {
            ((HTMLOptionElementImpl)options.item(i)).addValueIfSelected(processor, name, characterSet);
        }
    }

    @Override
    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    @Override
    public void reset() {
        HTMLCollection options = this.getOptions();
        for (int i = 0; i < options.getLength(); ++i) {
            HTMLControl optionElement = (HTMLControl)options.item(i);
            optionElement.reset();
        }
    }
}

