/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLControl;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLTextAreaElement;

public class HTMLTextAreaElementImpl
extends HTMLControl
implements HTMLTextAreaElement {
    private String _value;

    @Override
    ElementImpl create() {
        return new HTMLTextAreaElementImpl();
    }

    @Override
    public void blur() {
        this.handleEvent("onblur");
    }

    @Override
    public void focus() {
        this.handleEvent("onfocus");
    }

    @Override
    public String getAccessKey() {
        return this.getAttributeWithNoDefault("accesskey");
    }

    @Override
    public int getCols() {
        return this.getIntegerAttribute("cols");
    }

    @Override
    public String getDefaultValue() {
        Node node = this.getFirstChild();
        if (node == null || node.getNodeType() != 3) {
            return null;
        }
        return node.getNodeValue();
    }

    @Override
    public int getRows() {
        return this.getIntegerAttribute("rows");
    }

    @Override
    public void select() {
    }

    @Override
    public void setAccessKey(String accessKey) {
        this.setAttribute("accesskey", accessKey);
    }

    @Override
    public void setCols(int cols) {
        this.setAttribute("cols", cols);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        Text textNode = this.getOwnerDocument().createTextNode(defaultValue);
        Node child = this.getFirstChild();
        if (child == null) {
            this.appendChild(textNode);
        } else {
            this.replaceChild(textNode, child);
        }
    }

    @Override
    public void setRows(int rows) {
        this.setAttribute("rows", rows);
    }

    @Override
    public String getValue() {
        return this._value != null ? this._value : this.getDefaultValue();
    }

    @Override
    public void setValue(String value) {
        this._value = value;
    }

    @Override
    public void reset() {
        this._value = null;
    }
}

