/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.HTMLParser;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.parsing.HTMLParserListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessage;
import org.w3c.tidy.TidyMessageListener;
import org.xml.sax.SAXException;

class JTidyHTMLParser
implements HTMLParser {
    private static final char NBSP = '\u00a0';
    private static final String UTF_ENCODING = "UTF-8";

    JTidyHTMLParser() {
    }

    @Override
    public void parse(final URL pageURL, String pageText, final HTMLParserListener listener, DocumentAdapter adapter) throws IOException, SAXException {
        try {
            Tidy parser = JTidyHTMLParser.getParser(pageURL);
            if (listener != null) {
                TidyMessageListener tidyListener = new TidyMessageListener(){

                    public void messageReceived(TidyMessage message) {
                        if (message.getLevel() == TidyMessage.Level.ERROR) {
                            listener.error(pageURL, message.getMessage(), message.getLine(), message.getColumn());
                        } else if (message.getLevel() == TidyMessage.Level.WARNING) {
                            listener.warning(pageURL, message.getMessage(), message.getLine(), message.getColumn());
                        }
                    }
                };
                parser.setMessageListener(tidyListener);
            }
            Document jtidyDocument = parser.parseDOM((InputStream)new ByteArrayInputStream(pageText.getBytes(UTF_ENCODING)), null);
            HTMLDocumentImpl htmlDocument = new HTMLDocumentImpl();
            NodeList nl = jtidyDocument.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node importedNode = nl.item(i);
                if (importedNode.getNodeType() == 10 || importedNode.getNodeType() == -1) continue;
                htmlDocument.appendChild(htmlDocument.importNode(importedNode, true));
            }
            adapter.setDocument(htmlDocument);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding failed");
        }
    }

    @Override
    public String getCleanedText(String string) {
        return string == null ? "" : string.replace('\u00a0', ' ');
    }

    @Override
    public boolean supportsPreserveTagCase() {
        return false;
    }

    @Override
    public boolean supportsForceTagCase() {
        return false;
    }

    @Override
    public boolean supportsReturnHTMLDocument() {
        return true;
    }

    @Override
    public boolean supportsParserWarnings() {
        return true;
    }

    private static Tidy getParser(URL url) {
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("UTF8");
        tidy.setQuiet(true);
        tidy.setShowWarnings(HTMLParserFactory.isParserWarningsEnabled());
        tidy.setLiteralAttribs(true);
        return tidy;
    }
}

