/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.servletunit.ServletUnitOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

class ServletUnitHttpResponse
implements HttpServletResponse {
    private static final String RFC1123_DATE_SPEC = "EEE, dd MMM yyyy hh:mm:ss z";
    private boolean _committed;
    private Locale _locale = Locale.getDefault();
    private static final Hashtable ENCODING_MAP = new Hashtable();
    private String _contentType = "text/plain";
    private String _encoding;
    private PrintWriter _writer;
    private ServletOutputStream _servletStream;
    private ByteArrayOutputStream _outputStream;
    private int _status = 200;
    private String _statusMessage = "OK";
    private final Hashtable _headers = new Hashtable();
    private boolean _headersComplete;
    private Vector _cookies = new Vector();

    ServletUnitHttpResponse() {
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void addCookie(Cookie cookie) {
        this._cookies.addElement(cookie);
    }

    public boolean containsHeader(String name) {
        return this._headers.containsKey(name.toUpperCase());
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "");
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc);
        this._statusMessage = msg;
        this._writer = null;
        this._servletStream = null;
        this.setContentType("text/html");
        this.getWriter().println("<html><head><title>" + msg + "</title></head><body>" + msg + "</body></html>");
    }

    public void setStatus(int sc) {
        this._status = sc;
    }

    public String getHeader(String name) {
        return this.getHeaderField(name);
    }

    public void setStatus(int sc, String msg) {
        this.setStatus(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        Hashtable hashtable = this._headers;
        synchronized (hashtable) {
            this._headers.put(name.toUpperCase(), values);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, this.asHeaderValue(value));
    }

    private String asHeaderValue(int value) {
        return Integer.toString(value);
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, this.asDateHeaderValue(date));
    }

    private String asDateHeaderValue(long date) {
        Date value = new Date(date);
        SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_DATE_SPEC, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("Greenwich Mean Time"));
        return formatter.format(value);
    }

    public String getCharacterEncoding() {
        return this._encoding == null ? "iso-8859-1" : this._encoding;
    }

    public void setContentType(String type) {
        String[] typeAndEncoding = HttpUnitUtils.parseContentTypeHeader(type);
        this._contentType = typeAndEncoding[0];
        if (typeAndEncoding[1] != null) {
            this._encoding = typeAndEncoding[1];
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._writer != null) {
            throw new IllegalStateException("Tried to create output stream; writer already exists");
        }
        if (this._servletStream == null) {
            this._outputStream = new ByteArrayOutputStream();
            this._servletStream = new ServletUnitOutputStream(this._outputStream);
        }
        return this._servletStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this._servletStream != null) {
            throw new IllegalStateException("Tried to create writer; output stream already exists");
        }
        if (this._writer == null) {
            this._outputStream = new ByteArrayOutputStream();
            this._writer = new PrintWriter(new OutputStreamWriter((OutputStream)this._outputStream, this.getCharacterEncoding()));
        }
        return this._writer;
    }

    public void setContentLength(int len) {
        this.setIntHeader("Content-Length", len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        Hashtable hashtable = this._headers;
        synchronized (hashtable) {
            String key = name.toUpperCase();
            ArrayList<String> values = (ArrayList<String>)this._headers.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this._headers.put(key, values);
            }
            values.add(value);
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, this.asHeaderValue(value));
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, this.asDateHeaderValue(value));
    }

    public void setBufferSize(int size) {
        if (this.getContents().length != 0) {
            throw new IllegalStateException("May not set buffer size after data is written");
        }
    }

    public int getBufferSize() {
        return 0;
    }

    public boolean isCommitted() {
        return this._committed;
    }

    public void flushBuffer() throws IOException {
        this._committed = true;
    }

    public void reset() {
        this.resetBuffer();
        this._headers.clear();
        this._headersComplete = false;
        this._status = 200;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        if (this._encoding == null) {
            for (Map.Entry entry : ENCODING_MAP.entrySet()) {
                String locales = (String)entry.getValue();
                if (locales.indexOf(locale.getLanguage()) < 0 && locales.indexOf(locale.toString()) < 0) continue;
                this._encoding = (String)entry.getKey();
                return;
            }
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void resetBuffer() {
        if (this._committed) {
            throw new IllegalStateException("May not resetBuffer after response is committed");
        }
        this._outputStream = null;
        this._servletStream = null;
        this._writer = null;
    }

    byte[] getContents() {
        if (this._outputStream == null) {
            return new byte[0];
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        return this._outputStream.toByteArray();
    }

    public int getStatus() {
        return this._status;
    }

    String getMessage() {
        return this._statusMessage;
    }

    public String[] getHeaderFieldNames() {
        if (!this._headersComplete) {
            this.completeHeaders();
        }
        Vector names = new Vector();
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        Object[] result = new String[names.size()];
        names.copyInto(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getHeaderField(String name) {
        ArrayList values;
        if (!this._headersComplete) {
            this.completeHeaders();
        }
        Hashtable hashtable = this._headers;
        synchronized (hashtable) {
            values = (ArrayList)this._headers.get(name.toUpperCase());
        }
        return values == null ? null : (String)values.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeaderFields(String name) {
        ArrayList values;
        if (!this._headersComplete) {
            this.completeHeaders();
        }
        Hashtable hashtable = this._headers;
        synchronized (hashtable) {
            values = (ArrayList)this._headers.get(name.toUpperCase());
        }
        if (values == null) {
            return new String[0];
        }
        String[] results = new String[values.size()];
        return values.toArray(results);
    }

    public void setCharacterEncoding(String string) {
        this._encoding = string;
    }

    public String getContentType() {
        return this._contentType;
    }

    private void completeHeaders() {
        if (this._headersComplete) {
            return;
        }
        this.addCookieHeader();
        this.setHeader("Content-Type", this._contentType + "; charset=" + this.getCharacterEncoding());
        this._headersComplete = true;
    }

    private void addCookieHeader() {
        if (this._cookies.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Enumeration e = this._cookies.elements();
        while (e.hasMoreElements()) {
            Cookie cookie = (Cookie)e.nextElement();
            sb.append(cookie.getName()).append('=').append(cookie.getValue());
            if (cookie.getPath() != null) {
                sb.append(";path=").append(cookie.getPath());
            }
            if (cookie.getDomain() != null) {
                sb.append(";domain=").append(cookie.getDomain());
            }
            if (!e.hasMoreElements()) continue;
            sb.append(',');
        }
        this.setHeader("Set-Cookie", sb.toString());
    }

    public void setContentLengthLong(long len) {
        this.setContentLength((int)len);
    }

    public Collection<String> getHeaders(String name) {
        return new ArrayList<String>(Arrays.asList(this.getHeaderFields(name)));
    }

    public Collection<String> getHeaderNames() {
        return new ArrayList<String>(Arrays.asList(this.getHeaderFieldNames()));
    }

    static {
        ENCODING_MAP.put("iso-8859-1", "ca da de en es fi fr is it nl no pt sv ");
        ENCODING_MAP.put("iso-8859-2", "cs hr hu pl ro sh sk sl sq ");
        ENCODING_MAP.put("iso-8859-4", "et lt lv ");
        ENCODING_MAP.put("iso-8859-5", "be bg mk ru sr uk ");
        ENCODING_MAP.put("iso-8859-6", "ar ");
        ENCODING_MAP.put("iso-8859-7", "el ");
        ENCODING_MAP.put("iso-8859-8", "iw he ");
        ENCODING_MAP.put("iso-8859-9", "tr ");
        ENCODING_MAP.put("Shift_JIS", "ja ");
        ENCODING_MAP.put("EUC-KR", "ko ");
        ENCODING_MAP.put("TIS-620", "th ");
        ENCODING_MAP.put("GB2312", "zh ");
        ENCODING_MAP.put("Big5", "zh_TW zh_HK ");
    }
}

