/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.RequestDispatcherImpl;
import com.meterware.servletunit.WebApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServletUnitServletContext
implements ServletContext {
    private PrintStream _logStream = System.out;
    public static final String DEFAULT_SERVER_INFO = "ServletUnit test framework";
    private static final Vector EMPTY_VECTOR = new Vector();
    private Hashtable _attributes = new Hashtable();
    private WebApplication _application;

    ServletUnitServletContext(WebApplication application) {
        this._application = application;
    }

    public ServletContext getContext(String A) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    public URL getResource(String path) {
        try {
            File resourceFile = this._application.getResourceFile(path);
            return resourceFile == null ? null : resourceFile.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        try {
            File resourceFile = this._application.getResourceFile(path);
            return resourceFile == null ? null : new FileInputStream(resourceFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        try {
            URL url = new URL("http", "localhost", this._application.getContextPath() + path);
            return new RequestDispatcherImpl(this._application, url);
        }
        catch (ServletException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public RequestDispatcher getNamedDispatcher(String A) {
        return null;
    }

    public Servlet getServlet(String A) {
        return null;
    }

    public Enumeration getServlets() {
        return EMPTY_VECTOR.elements();
    }

    public Enumeration getServletNames() {
        return EMPTY_VECTOR.elements();
    }

    public void log(String message) {
        this._logStream.println(message);
    }

    public void log(Exception e, String message) {
        this.log(message, e);
    }

    public void log(String message, Throwable t) {
        this._logStream.print(message);
        this._logStream.print(":");
        if (t != null) {
            t.printStackTrace(this._logStream);
        }
    }

    public String getRealPath(String path) {
        return this._application.getResourceFile(path).getAbsolutePath();
    }

    public String getServerInfo() {
        return DEFAULT_SERVER_INFO;
    }

    public String getInitParameter(String name) {
        return (String)this.getContextParams().get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.getContextParams().keys();
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.keys();
    }

    public void setAttribute(String name, Object attribute) {
        if (!this._attributes.containsKey(name)) {
            this._attributes.put(name, attribute);
            this._application.sendAttributeAdded(name, attribute);
        } else {
            Object oldValue = this._attributes.get(name);
            this._attributes.put(name, attribute);
            this._application.sendAttributeReplaced(name, oldValue);
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this._attributes.get(name);
        this._attributes.remove(name);
        this._application.sendAttributeRemoved(name, oldValue);
    }

    public Set getResourcePaths(String path) {
        return null;
    }

    public String getServletContextName() {
        return this._application.getDisplayName();
    }

    public String getContextPath() {
        return this._application.getContextPath();
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    void setInitParameter(String name, Object initParameter) {
        this.getContextParams().put(name, initParameter);
    }

    void removeInitParameter(String name) {
        this.getContextParams().remove(name);
    }

    private Hashtable getContextParams() {
        return this._application.getContextParameters();
    }

    public void setLogStream(PrintStream logStream) {
        this._logStream = logStream;
    }

    public int getEffectiveMajorVersion() {
        return this.getMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.getMinorVersion();
    }

    public boolean setInitParameter(String name, String value) {
        return false;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return Collections.emptyMap();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return Collections.emptyMap();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return Collections.singleton(SessionTrackingMode.COOKIE);
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.getDefaultSessionTrackingModes();
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        final WebApplication application = this._application;
        return new JspConfigDescriptor(){

            public Collection<TaglibDescriptor> getTaglibs() {
                ArrayList<TaglibDescriptor> result = new ArrayList<TaglibDescriptor>();
                Document document = application.getWebXml();
                for (Node child = document.getDocumentElement().getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1 || !"jsp-config".equals(child.getNodeName())) continue;
                    for (Node entry = child.getFirstChild(); entry != null; entry = entry.getNextSibling()) {
                        if (entry.getNodeType() != 1 || !"taglib".equals(entry.getNodeName())) continue;
                        String searchUri = null;
                        String searchLocation = null;
                        for (Node property = entry.getFirstChild(); property != null; property = property.getNextSibling()) {
                            if (property.getNodeType() != 1) continue;
                            if ("taglib-uri".equals(property.getNodeName())) {
                                searchUri = property.getTextContent();
                                continue;
                            }
                            if (!"taglib-location".equals(property.getNodeName())) continue;
                            searchLocation = property.getTextContent();
                        }
                        final String uri = searchUri;
                        final String location = searchLocation;
                        result.add(new TaglibDescriptor(){

                            public String getTaglibURI() {
                                return uri;
                            }

                            public String getTaglibLocation() {
                                return location;
                            }
                        });
                    }
                }
                return result;
            }

            public Collection<JspPropertyGroupDescriptor> getJspPropertyGroups() {
                return Collections.emptyList();
            }
        };
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException();
    }

    public String getVirtualServerName() {
        return "localhost";
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException();
    }

    public int getSessionTimeout() {
        return 0;
    }

    public void setSessionTimeout(int sessionTimeout) {
        throw new UnsupportedOperationException();
    }

    public String getRequestCharacterEncoding() {
        return "utf-8";
    }

    public void setRequestCharacterEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    public String getResponseCharacterEncoding() {
        return "utf-8";
    }

    public void setResponseCharacterEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }
}

