/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.dom.HTMLInputElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;

abstract class BooleanFormControl
extends FormControl {
    private String[] _displayedValue;
    private HTMLInputElementImpl _element;

    @Override
    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    public BooleanFormControl(WebForm form, HTMLInputElementImpl element) {
        super(form, element);
        this._element = element;
        this._displayedValue = new String[]{this.readDisplayedValue(element)};
    }

    private String readDisplayedValue(Node node) {
        Node nextSibling;
        for (nextSibling = node.getNextSibling(); nextSibling != null && nextSibling.getNodeType() != 3 && nextSibling.getNodeType() != 1; nextSibling = nextSibling.getNextSibling()) {
        }
        if (nextSibling == null || nextSibling.getNodeType() != 3) {
            return "";
        }
        return nextSibling.getNodeValue();
    }

    boolean isChecked() {
        return this._element.getChecked();
    }

    @Override
    protected String getValueAttribute() {
        return this.emptyIfNull(this._element.getValue());
    }

    @Override
    protected void setValueAttribute(String value) {
        this._element.setValue(value);
    }

    public void setChecked(boolean checked) {
        this._element.setChecked(checked);
    }

    @Override
    public String[] getValues() {
        return this.isChecked() ? this.toArray(this.getQueryValue()) : NO_VALUE;
    }

    @Override
    public String[] getOptionValues() {
        return this.isReadOnly() && !this.isChecked() ? NO_VALUE : this.toArray(this.getQueryValue());
    }

    @Override
    protected String[] getDisplayedOptions() {
        return this._displayedValue;
    }

    @Override
    protected void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this.isChecked() && !this.isDisabled()) {
            processor.addParameter(this.getName(), this.getQueryValue(), characterSet);
        }
    }

    @Override
    void claimRequiredValues(List values) {
        if (this.isValueRequired()) {
            this.claimValueIsRequired(values, this.getQueryValue());
        }
    }

    protected boolean isValueRequired() {
        return this.isReadOnly() && this.isChecked();
    }

    abstract String getQueryValue();

    private String[] toArray(String value) {
        return new String[]{value};
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
            super(BooleanFormControl.this);
        }

        @Override
        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("value")) {
                return BooleanFormControl.this.getQueryValue();
            }
            if (propertyName.equalsIgnoreCase("checked")) {
                return BooleanFormControl.this.isChecked() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (propertyName.equalsIgnoreCase("defaultchecked")) {
                return BooleanFormControl.this._element.getDefaultChecked() ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.get(propertyName);
        }

        @Override
        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("checked")) {
                BooleanFormControl.this.setChecked(value instanceof Boolean && (Boolean)value != false);
            } else {
                super.set(propertyName, value);
            }
        }
    }
}

