/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;

abstract class HTMLElementBase
implements HTMLElement {
    private Node _node;
    private ScriptingHandler _scriptable;
    private Set _supportedAttributes = new HashSet();

    @Override
    public String getID() {
        return this.getAttribute("id");
    }

    @Override
    public String getClassName() {
        return this.getAttribute("class");
    }

    @Override
    public String getTitle() {
        return this.getAttribute("title");
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public ScriptingHandler getScriptingHandler() {
        if (this._scriptable == null) {
            this._scriptable = HttpUnitOptions.getScriptingEngine().createHandler(this);
        }
        return this._scriptable;
    }

    @Override
    public boolean doEvent(String eventScript) {
        return this.doEventScript(eventScript);
    }

    @Override
    public boolean doEventScript(String eventScript) {
        return this.getScriptingHandler().doEventScript(eventScript);
    }

    @Override
    public boolean handleEvent(String eventName) {
        return this.getScriptingHandler().handleEvent(eventName);
    }

    @Override
    public String getText() {
        if (this._node.getNodeType() == 3) {
            return this._node.getNodeValue().trim();
        }
        if (this._node == null || !this._node.hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(this._node.getChildNodes()).trim();
    }

    @Override
    public String getTagName() {
        return this._node.getNodeName();
    }

    protected HTMLElementBase(Node node) {
        this._node = node;
        this.supportAttribute("id");
        this.supportAttribute("class");
        this.supportAttribute("title");
        this.supportAttribute("name");
    }

    @Override
    public String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this.getNode(), name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        NodeUtils.setNodeAttribute(this.getNode(), name, value == null ? null : value.toString());
    }

    @Override
    public void removeAttribute(String name) {
        NodeUtils.removeNodeAttribute(this.getNode(), name);
    }

    @Override
    public boolean isSupportedAttribute(String name) {
        return this._supportedAttributes.contains(name);
    }

    protected String getAttribute(String name, String defaultValue) {
        return NodeUtils.getNodeAttribute(this.getNode(), name, defaultValue);
    }

    @Override
    public Node getNode() {
        return this._node;
    }

    protected void supportAttribute(String name) {
        this._supportedAttributes.add(name);
    }

    @Override
    public ScriptableDelegate newScriptable() {
        return new HTMLElementScriptable(this);
    }
}

