/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import java.util.Map;
import java.util.Properties;

public class HttpHeader {
    private String _label;
    private Map _properties;

    public HttpHeader(String headerString) {
        this(headerString, null);
    }

    public HttpHeader(String headerString, String defaultLabel) {
        if (headerString != null) {
            int index = headerString.indexOf(32);
            if (index < 0) {
                this._label = defaultLabel;
                this._properties = HttpHeader.loadProperties(headerString);
            } else {
                this._label = headerString.substring(0, index);
                this._properties = HttpHeader.loadProperties(headerString.substring(index + 1));
            }
        }
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.getLabel().equals(((HttpHeader)obj).getLabel()) && this.getProperties().equals(((HttpHeader)obj).getProperties());
    }

    public String toString() {
        return this.getLabel() + " " + String.valueOf(this.getProperties());
    }

    protected String getProperty(String key) {
        return this.unQuote((String)this.getProperties().get(key));
    }

    private String unQuote(String value) {
        if (value == null || value.length() <= 1 || !value.startsWith("\"") || !value.endsWith("\"")) {
            return value;
        }
        return value.substring(1, value.length() - 1);
    }

    private static Map loadProperties(String parameterString) {
        Properties properties = new Properties();
        char[] chars = parameterString.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                ++i;
            }
            while (i < chars.length && Character.isJavaIdentifierPart(chars[i])) {
                sb.append(chars[i++]);
            }
            String name = sb.toString();
            sb.setLength(0);
            while (i < chars.length && chars[i] != '=') {
                ++i;
            }
            if (i == chars.length) break;
            ++i;
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                ++i;
            }
            if (i == chars.length) break;
            if (chars[i] == '\"') {
                sb.append(chars[i++]);
                while (i < chars.length && chars[i] != '\"') {
                    sb.append(chars[i++]);
                }
                sb.append('\"');
                if (i < chars.length) {
                    ++i;
                }
            } else {
                while (i < chars.length && Character.isJavaIdentifierPart(chars[i])) {
                    sb.append(chars[i++]);
                }
            }
            properties.setProperty(name, sb.toString());
            sb.setLength(0);
            while (i < chars.length && chars[i] != ',') {
                ++i;
            }
            if (i == chars.length) break;
        }
        return properties;
    }

    public String getLabel() {
        return this._label;
    }

    public Map getProperties() {
        return this._properties;
    }
}

