/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingEngineFactory;
import com.meterware.httpunit.scripting.ScriptingHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public abstract class HttpUnitOptions {
    private static final String RCSID = "$Id: HttpUnitOptions.java 317988 2023-02-16 06:59:41Z bhu $";
    public static final String ORIGINAL_SCRIPTING_ENGINE_FACTORY = "com.meterware.httpunit.javascript.JavaScriptEngineFactory";
    private static final String NEW_SCRIPTING_ENGINE_FACTORY = "com.meterware.httpunit.dom.DomBasedScriptingEngineFactory";
    public static final String DEFAULT_SCRIPT_ENGINE_FACTORY = "com.meterware.httpunit.javascript.JavaScriptEngineFactory";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final ScriptingEngineFactory NULL_SCRIPTING_ENGINE_FACTORY = new ScriptingEngineFactory(){

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void associate(WebResponse response) {
        }

        @Override
        public void load(WebResponse response) {
        }

        @Override
        public void setThrowExceptionsOnError(boolean throwExceptions) {
        }

        @Override
        public boolean isThrowExceptionsOnError() {
            return false;
        }

        @Override
        public String[] getErrorMessages() {
            return new String[0];
        }

        @Override
        public void clearErrorMessages() {
        }

        @Override
        public ScriptingHandler createHandler(HTMLElement element) {
            return ScriptableDelegate.NULL_SCRIPT_ENGINE;
        }

        @Override
        public ScriptingHandler createHandler(WebResponse response) {
            return ScriptableDelegate.NULL_SCRIPT_ENGINE;
        }
    };
    private static Set _customAttributes = null;
    private static boolean _exceptionsOnErrorStatus = true;
    private static boolean _parameterValuesValidated = true;
    private static boolean _imagesTreatedAsAltText;
    private static boolean _loggingHttpHeaders;
    private static boolean _matchesIgnoreCase;
    private static boolean _postIncludesCharset;
    private static boolean _checkContentLength;
    private static int _redirectDelay;
    private static String _characterSet;
    private static String _contentType;
    private static String _scriptEngineClassName;
    private static ScriptingEngineFactory _scriptingEngine;
    private static boolean _scriptingEnabled;
    private static boolean _exceptionsThrownOnScriptError;
    private static int _javaScriptOptimizationLevel;

    public static void reset() {
        _exceptionsOnErrorStatus = true;
        _parameterValuesValidated = true;
        _imagesTreatedAsAltText = false;
        _loggingHttpHeaders = false;
        _matchesIgnoreCase = true;
        _checkContentLength = false;
        _redirectDelay = 0;
        _characterSet = "iso-8859-1";
        _contentType = DEFAULT_CONTENT_TYPE;
        _postIncludesCharset = false;
        _exceptionsThrownOnScriptError = true;
        _customAttributes = null;
        _javaScriptOptimizationLevel = -1;
        HttpUnitOptions.setScriptEngineClassName("com.meterware.httpunit.javascript.JavaScriptEngineFactory");
        HttpUnitOptions.setScriptingEnabled(true);
    }

    public static boolean isAcceptCookies() {
        return ClientProperties.getDefaultProperties().isAcceptCookies();
    }

    public static void setAcceptCookies(boolean acceptCookies) {
        ClientProperties.getDefaultProperties().setAcceptCookies(acceptCookies);
    }

    public static boolean isAcceptGzip() {
        return ClientProperties.getDefaultProperties().isAcceptGzip();
    }

    public static void setAcceptGzip(boolean acceptGzip) {
        ClientProperties.getDefaultProperties().setAcceptGzip(acceptGzip);
    }

    public static void resetDefaultCharacterSet() {
        _characterSet = "iso-8859-1";
    }

    public static void resetDefaultContentType() {
        _contentType = DEFAULT_CONTENT_TYPE;
    }

    public static void setDefaultCharacterSet(String characterSet) {
        _characterSet = characterSet;
    }

    public static String getDefaultCharacterSet() {
        return _characterSet;
    }

    public static boolean isCheckContentLength() {
        return _checkContentLength;
    }

    public static void setCheckContentLength(boolean checkContentLength) {
        _checkContentLength = checkContentLength;
    }

    public static void setPostIncludesCharset(boolean postIncludesCharset) {
        _postIncludesCharset = postIncludesCharset;
    }

    public static boolean isPostIncludesCharset() {
        return _postIncludesCharset;
    }

    public static void setDefaultContentType(String contentType) {
        _contentType = contentType;
    }

    public static String getDefaultContentType() {
        return _contentType;
    }

    public static boolean getParserWarningsEnabled() {
        return HTMLParserFactory.isParserWarningsEnabled();
    }

    public static void setParserWarningsEnabled(boolean enabled) {
        HTMLParserFactory.setParserWarningsEnabled(enabled);
    }

    public static void setExceptionsThrownOnErrorStatus(boolean enabled) {
        _exceptionsOnErrorStatus = enabled;
    }

    public static boolean getExceptionsThrownOnErrorStatus() {
        return _exceptionsOnErrorStatus;
    }

    public static boolean getParameterValuesValidated() {
        return _parameterValuesValidated;
    }

    public static void setParameterValuesValidated(boolean validated) {
        _parameterValuesValidated = validated;
    }

    public static boolean getImagesTreatedAsAltText() {
        return _imagesTreatedAsAltText;
    }

    public static void setImagesTreatedAsAltText(boolean asText) {
        _imagesTreatedAsAltText = asText;
    }

    public static boolean getMatchesIgnoreCase() {
        return _matchesIgnoreCase;
    }

    public static void setMatchesIgnoreCase(boolean ignoreCase) {
        _matchesIgnoreCase = ignoreCase;
    }

    public static boolean isLoggingHttpHeaders() {
        return _loggingHttpHeaders;
    }

    public static void setLoggingHttpHeaders(boolean enabled) {
        _loggingHttpHeaders = enabled;
    }

    public static boolean getAutoRedirect() {
        return ClientProperties.getDefaultProperties().isAutoRedirect();
    }

    public static void setAutoRedirect(boolean autoRedirect) {
        ClientProperties.getDefaultProperties().setAutoRedirect(autoRedirect);
    }

    public static int getRedirectDelay() {
        return _redirectDelay;
    }

    public static void setRedirectDelay(int delayInMilliseconds) {
        _redirectDelay = delayInMilliseconds;
    }

    public static boolean getAutoRefresh() {
        return ClientProperties.getDefaultProperties().isAutoRefresh();
    }

    public static void setAutoRefresh(boolean autoRefresh) {
        ClientProperties.getDefaultProperties().setAutoRefresh(autoRefresh);
    }

    public static Vector getHtmlErrorListeners() {
        return null;
    }

    public static String getScriptEngineClassName() {
        return _scriptEngineClassName;
    }

    public static void setScriptEngineClassName(String scriptEngineClassName) {
        if (_scriptEngineClassName == null || !_scriptEngineClassName.equals(scriptEngineClassName)) {
            _scriptingEngine = null;
        }
        _scriptEngineClassName = scriptEngineClassName;
    }

    public static ScriptingEngineFactory getScriptingEngine() {
        if (_scriptingEngine == null) {
            try {
                Class<?> factoryClass = Class.forName(_scriptEngineClassName);
                ScriptingEngineFactory factory = (ScriptingEngineFactory)factoryClass.newInstance();
                _scriptingEngine = factory.isEnabled() ? factory : NULL_SCRIPTING_ENGINE_FACTORY;
                _scriptingEngine.setThrowExceptionsOnError(_exceptionsThrownOnScriptError);
            }
            catch (ClassNotFoundException e) {
                HttpUnitOptions.disableScripting(e, "Unable to find scripting engine factory class ");
            }
            catch (InstantiationException e) {
                HttpUnitOptions.disableScripting(e, "Unable to instantiate scripting engine factory class ");
            }
            catch (IllegalAccessException e) {
                HttpUnitOptions.disableScripting(e, "Unable to create scripting engine factory class ");
            }
        }
        return _scriptingEngine;
    }

    public static void setScriptingEnabled(boolean scriptingEnabled) {
        if (scriptingEnabled != _scriptingEnabled) {
            _scriptingEngine = scriptingEnabled ? null : NULL_SCRIPTING_ENGINE_FACTORY;
        }
        _scriptingEnabled = scriptingEnabled;
    }

    public static boolean isScriptingEnabled() {
        return _scriptingEnabled;
    }

    public static void setExceptionsThrownOnScriptError(boolean throwExceptions) {
        _exceptionsThrownOnScriptError = throwExceptions;
        HttpUnitOptions.getScriptingEngine().setThrowExceptionsOnError(throwExceptions);
    }

    public static boolean getExceptionsThrownOnScriptError() {
        return _exceptionsThrownOnScriptError;
    }

    public static String[] getScriptErrorMessages() {
        return HttpUnitOptions.getScriptingEngine().getErrorMessages();
    }

    public static void clearScriptErrorMessages() {
        HttpUnitOptions.getScriptingEngine().clearErrorMessages();
    }

    private static void disableScripting(Exception e, String errorMessage) {
        System.err.println(errorMessage + _scriptEngineClassName);
        System.err.println(String.valueOf(e));
        System.err.println("JavaScript execution disabled");
        _scriptingEngine = NULL_SCRIPTING_ENGINE_FACTORY;
    }

    public static void addCustomAttribute(String attributeName) {
        if (_customAttributes == null) {
            _customAttributes = new HashSet();
        }
        _customAttributes.add(attributeName);
    }

    static Set getCustomAttributes() {
        return _customAttributes;
    }

    public static int getJavaScriptOptimizationLevel() {
        return _javaScriptOptimizationLevel;
    }

    public static void setJavaScriptOptimizationLevel(int scriptOptimizationLevel) {
        _javaScriptOptimizationLevel = scriptOptimizationLevel;
    }

    static {
        _matchesIgnoreCase = true;
        _postIncludesCharset = false;
        _checkContentLength = false;
        _characterSet = "iso-8859-1";
        _contentType = DEFAULT_CONTENT_TYPE;
        _scriptingEnabled = true;
        _exceptionsThrownOnScriptError = true;
        _javaScriptOptimizationLevel = -1;
        HttpUnitOptions.reset();
    }
}

