/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.RadioButtonFormControl;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.controls.IllegalParameterValueException;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RadioGroupFormControl
extends FormControl {
    private List _buttonList = new ArrayList();
    private RadioButtonFormControl[] _buttons;
    private String[] _allowedValues;

    @Override
    public String getType() {
        return "undefined";
    }

    public RadioGroupFormControl(WebForm form) {
        super(form);
    }

    void addRadioButton(RadioButtonFormControl control) {
        this._buttonList.add(control);
        this._buttons = null;
        this._allowedValues = null;
    }

    @Override
    public String[] getValues() {
        for (int i = 0; i < this.getButtons().length; ++i) {
            if (!this.getButtons()[i].isChecked()) continue;
            return this.getButtons()[i].getValues();
        }
        return NO_VALUE;
    }

    @Override
    public String[] getOptionValues() {
        ArrayList<String> valueList = new ArrayList<String>();
        RadioButtonFormControl[] buttons = this.getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            valueList.addAll(Arrays.asList(((FormControl)buttons[i]).getOptionValues()));
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    @Override
    protected String[] getDisplayedOptions() {
        ArrayList<String> valueList = new ArrayList<String>();
        RadioButtonFormControl[] buttons = this.getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            valueList.addAll(Arrays.asList(((FormControl)buttons[i]).getDisplayedOptions()));
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    @Override
    Object getDelegate() {
        ScriptableDelegate[] delegates = new ScriptableDelegate[this.getButtons().length];
        for (int i = 0; i < delegates.length; ++i) {
            delegates[i] = (ScriptableDelegate)this.getButtons()[i].getScriptingHandler();
        }
        return delegates;
    }

    @Override
    protected void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        for (int i = 0; i < this.getButtons().length; ++i) {
            this.getButtons()[i].addValues(processor, characterSet);
        }
    }

    @Override
    void claimRequiredValues(List values) {
        for (int i = 0; i < this.getButtons().length; ++i) {
            this.getButtons()[i].claimRequiredValues(values);
        }
    }

    @Override
    protected void claimUniqueValue(List values) {
        int matchingButtonIndex = -1;
        for (int i = 0; i < this.getButtons().length && matchingButtonIndex < 0; ++i) {
            if (this.getButtons()[i].isReadOnly() || !values.contains(this.getButtons()[i].getQueryValue())) continue;
            matchingButtonIndex = i;
        }
        if (matchingButtonIndex < 0) {
            throw new IllegalParameterValueException(this.getButtons()[0].getName(), values, this.getAllowedValues());
        }
        boolean wasChecked = this.getButtons()[matchingButtonIndex].isChecked();
        for (int i = 0; i < this.getButtons().length; ++i) {
            if (this.getButtons()[i].isReadOnly()) continue;
            this.getButtons()[i].setChecked(i == matchingButtonIndex);
        }
        values.remove(this.getButtons()[matchingButtonIndex].getQueryValue());
        if (!wasChecked) {
            this.getButtons()[matchingButtonIndex].sendOnClickEvent();
        }
    }

    @Override
    protected void reset() {
        for (int i = 0; i < this.getButtons().length; ++i) {
            this.getButtons()[i].reset();
        }
    }

    private String[] getAllowedValues() {
        if (this._allowedValues == null) {
            this._allowedValues = new String[this.getButtons().length];
            for (int i = 0; i < this._allowedValues.length; ++i) {
                this._allowedValues[i] = this.getButtons()[i].getQueryValue();
            }
        }
        return this._allowedValues;
    }

    private RadioButtonFormControl[] getButtons() {
        if (this._buttons == null) {
            this._buttons = this._buttonList.toArray(new RadioButtonFormControl[this._buttonList.size()]);
        }
        return this._buttons;
    }
}

