/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.AppletStubImpl;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.applet.Applet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLAppletElement;
import org.xml.sax.SAXException;

public class WebApplet
extends HTMLElementBase {
    private WebResponse _response;
    private String _baseTarget;
    private Applet _applet;
    private HashMap _parameters;
    private String[] _parameterNames;
    private final String CLASS_EXTENSION = ".class";
    private HTMLAppletElement _element;

    public WebApplet(WebResponse response, HTMLAppletElement element, String baseTarget) {
        super(element);
        this._element = element;
        this._response = response;
        this._baseTarget = baseTarget;
    }

    public URL getCodeBaseURL() throws MalformedURLException {
        return new URL(this._response.getURL(), this.getCodeBase());
    }

    private String getCodeBase() {
        String codeBaseAttribute = this._element.getCodeBase();
        return codeBaseAttribute.endsWith("/") ? codeBaseAttribute : codeBaseAttribute + "/";
    }

    public String getMainClassName() {
        String className = this._element.getCode();
        if (className.endsWith(".class")) {
            className = className.substring(0, className.lastIndexOf(".class"));
        }
        className = className.replace('/', '.').replace('\\', '.');
        return className;
    }

    public int getWidth() {
        return Integer.parseInt(this.getAttribute("width"));
    }

    public int getHeight() {
        return Integer.parseInt(this.getAttribute("height"));
    }

    public String getArchiveSpecification() {
        String specification = this.getParameter("archive");
        if (specification == null) {
            specification = this.getAttribute("archive");
        }
        return specification;
    }

    List getArchiveList() throws MalformedURLException {
        ArrayList<URL> al = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(this.getArchiveSpecification(), ",");
        while (st.hasMoreTokens()) {
            al.add(new URL(this.getCodeBaseURL(), st.nextToken()));
        }
        return al;
    }

    public String[] getParameterNames() {
        if (this._parameterNames == null) {
            ArrayList al = new ArrayList(this.getParameterMap().keySet());
            this._parameterNames = al.toArray(new String[al.size()]);
        }
        return this._parameterNames;
    }

    public String getParameter(String name) {
        return (String)this.getParameterMap().get(name);
    }

    private Map getParameterMap() {
        if (this._parameters == null) {
            this._parameters = new HashMap();
            NodeList nl = ((Element)this.getNode()).getElementsByTagName("param");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                this._parameters.put(NodeUtils.getNodeAttribute(n, "name", ""), NodeUtils.getNodeAttribute(n, "value", ""));
            }
        }
        return this._parameters;
    }

    public Applet getApplet() throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this._applet == null) {
            URLClassLoader cl = new URLClassLoader(this.getClassPath(), null);
            Object o = cl.loadClass(this.getMainClassName()).newInstance();
            if (!(o instanceof Applet)) {
                throw new RuntimeException(this.getMainClassName() + " is not an Applet");
            }
            this._applet = (Applet)o;
            this._applet.setStub(new AppletStubImpl(this));
        }
        return this._applet;
    }

    private URL[] getClassPath() throws MalformedURLException {
        List classPath = this.getArchiveList();
        classPath.add(this.getCodeBaseURL());
        return classPath.toArray(new URL[classPath.size()]);
    }

    String getBaseTarget() {
        return this._baseTarget;
    }

    WebApplet[] getAppletsInPage() {
        try {
            return this._response.getApplets();
        }
        catch (SAXException e) {
            HttpUnitUtils.handleException(e);
            return null;
        }
    }

    void sendRequest(URL url, String target) {
        GetMethodWebRequest wr = new GetMethodWebRequest(null, url.toExternalForm(), target);
        try {
            this._response.getWindow().getResponse(wr);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Override
    public ScriptableDelegate newScriptable() {
        return new HTMLElementScriptable(this);
    }

    @Override
    public ScriptableDelegate getParentDelegate() {
        return this._response.getDocumentScriptable();
    }
}

