/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FixedURLWebRequestSource;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.ParsedHTML;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.net.URL;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLImageElement;

public class WebImage
extends FixedURLWebRequestSource {
    private HTMLImageElement _element;
    private ParsedHTML _parsedHTML;

    WebImage(WebResponse response, ParsedHTML parsedHTML, URL baseURL, HTMLImageElement element, FrameSelector sourceFrame, String defaultTarget, String characterSet) {
        super(response, element, baseURL, "src", sourceFrame, defaultTarget, characterSet);
        this._element = element;
        this._parsedHTML = parsedHTML;
    }

    @Override
    public String getName() {
        return this._element.getName();
    }

    public String getSource() {
        return this._element.getSrc();
    }

    public String getAltText() {
        return this._element.getAlt();
    }

    public WebLink getLink() {
        return this._parsedHTML.getFirstMatchingLink(new HTMLElementPredicate(){

            @Override
            public boolean matchesCriteria(Object link, Object parentNode) {
                for (Node parent = (Node)parentNode; parent != null; parent = parent.getParentNode()) {
                    if (!parent.equals(((WebLink)link).getElement())) continue;
                    return true;
                }
                return false;
            }
        }, this._element.getParentNode());
    }

    @Override
    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    public class Scriptable
    extends HTMLElementScriptable
    implements NamedDelegate {
        public Scriptable() {
            super(WebImage.this);
        }

        @Override
        public String getName() {
            return WebImage.this.getID().length() != 0 ? WebImage.this.getID() : WebImage.this.getName();
        }

        @Override
        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("src")) {
                return WebImage.this.getSource();
            }
            if (propertyName.equalsIgnoreCase("name")) {
                return this.getName();
            }
            return super.get(propertyName);
        }

        @Override
        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("src")) {
                if (value != null) {
                    WebImage.this._element.setSrc(value.toString());
                }
            } else {
                super.set(propertyName, value);
            }
        }
    }
}

