/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FixedURLWebRequestSource;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebLink
extends FixedURLWebRequestSource {
    public static final HTMLElementPredicate MATCH_URL_STRING = new HTMLElementPredicate(){

        @Override
        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.contains(((WebLink)htmlElement).getURLString(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_TEXT = new HTMLElementPredicate(){

        @Override
        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.matches(((WebLink)htmlElement).getText(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_CONTAINED_TEXT = new HTMLElementPredicate(){

        @Override
        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.contains(((WebLink)htmlElement).getText(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_ID = new HTMLElementPredicate(){

        @Override
        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.matches(((WebLink)htmlElement).getID(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_NAME = new HTMLElementPredicate(){

        @Override
        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            return HttpUnitUtils.matches(((WebLink)htmlElement).getName(), (String)criteria);
        }
    };

    public String getURLString() {
        return this.getRelativeURL();
    }

    @Override
    public String getText() {
        if (this.getElement().getNodeName().equalsIgnoreCase("area")) {
            return this.getAttribute("alt");
        }
        return super.getText();
    }

    public String asText() {
        return this.getText();
    }

    public WebResponse click() throws IOException, SAXException {
        if (this.handleEvent("onclick")) {
            ((HTMLElementImpl)this.getNode()).doClickAction();
        }
        return this.getCurrentFrameContents();
    }

    public void mouseOver() {
        this.handleEvent("onmouseover");
    }

    @Override
    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    WebLink(WebResponse response, URL baseURL, Node node, FrameSelector sourceFrame, String defaultTarget, String characterSet) {
        super(response, node, baseURL, "href", sourceFrame, defaultTarget, characterSet);
    }

    public class Scriptable
    extends HTMLElementScriptable
    implements NamedDelegate {
        public Scriptable() {
            super(WebLink.this);
        }

        @Override
        public String getName() {
            return WebLink.this.getID().length() != 0 ? WebLink.this.getID() : WebLink.this.getName();
        }

        @Override
        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("href")) {
                return this.getReference().toExternalForm();
            }
            return super.get(propertyName);
        }

        @Override
        public void set(String propertyName, Object value) {
            if (propertyName.equals("href")) {
                WebLink.this.setDestination((String)value);
            } else {
                super.set(propertyName, value);
            }
        }

        private URL getReference() {
            try {
                return WebLink.this.getRequest().getURL();
            }
            catch (MalformedURLException e) {
                return WebLink.this.getBaseURL();
            }
        }
    }
}

