/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.cookies;

import com.meterware.httpunit.cookies.Cookie;
import com.meterware.httpunit.cookies.CookieProperties;
import com.meterware.httpunit.cookies.CookieSource;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class CookieJar {
    private static final int DEFAULT_HEADER_SIZE = 80;
    private ArrayList _cookies = new ArrayList();
    private ArrayList _globalCookies = new ArrayList();
    private CookiePress _press;

    public CookieJar() {
        this._press = new CookiePress(null);
    }

    public CookieJar(CookieSource source) {
        this._press = new CookiePress(source.getURL());
        this.findCookies(source.getHeaderFields("Set-Cookie"), new RFC2109CookieRecipe());
        this.findCookies(source.getHeaderFields("Set-Cookie2"), new RFC2965CookieRecipe());
    }

    private void findCookies(String[] cookieHeader, CookieRecipe recipe) {
        for (int i = 0; i < cookieHeader.length; ++i) {
            recipe.findCookies(cookieHeader[i]);
        }
    }

    public void clear() {
        this._cookies.clear();
        this._globalCookies.clear();
    }

    public void addCookie(String name, String value) {
        this._globalCookies.add(new Cookie(name, value));
    }

    public void putCookie(String name, String value) {
        Cookie cookie;
        boolean foundCookie = false;
        Iterator iterator = this._globalCookies.iterator();
        while (iterator.hasNext()) {
            cookie = (Cookie)iterator.next();
            if (!name.equals(cookie.getName())) continue;
            foundCookie = true;
            if (value != null) {
                cookie.setValue(value);
                continue;
            }
            iterator.remove();
        }
        iterator = this._cookies.iterator();
        while (iterator.hasNext()) {
            cookie = (Cookie)iterator.next();
            if (!name.equals(cookie.getName())) continue;
            foundCookie = true;
            if (value != null) {
                cookie.setValue(value);
                continue;
            }
            iterator.remove();
        }
        if (!foundCookie) {
            this._globalCookies.add(new Cookie(name, value));
        }
    }

    public void putSingleUseCookie(String name, String value, String domain, String path) {
        for (Cookie cookie : this._globalCookies) {
            if (!name.equals(cookie.getName())) continue;
            return;
        }
        Iterator iterator = this._cookies.iterator();
        while (iterator.hasNext()) {
            Cookie cookie;
            cookie = (Cookie)iterator.next();
            if (!name.equals(cookie.getName())) continue;
            iterator.remove();
        }
        this._cookies.add(new Cookie(name, value, domain, path));
    }

    public String[] getCookieNames() {
        int i;
        int numGlobalCookies = this._globalCookies.size();
        String[] names = new String[this._cookies.size() + numGlobalCookies];
        for (i = 0; i < numGlobalCookies; ++i) {
            names[i] = ((Cookie)this._globalCookies.get(i)).getName();
        }
        for (i = numGlobalCookies; i < names.length; ++i) {
            names[i] = ((Cookie)this._cookies.get(i - numGlobalCookies)).getName();
        }
        return names;
    }

    public Collection getCookies() {
        Collection collection = (Collection)this._cookies.clone();
        collection.addAll(this._globalCookies);
        return collection;
    }

    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        return cookie == null ? null : cookie.getValue();
    }

    public Cookie getCookie(String name) {
        if (name == null) {
            throw new IllegalArgumentException("getCookieValue: no name specified");
        }
        for (Cookie cookie : this._cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        for (Cookie cookie : this._globalCookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public String getCookieHeaderField(URL targetURL) {
        if (this._cookies.isEmpty() && this._globalCookies.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(80);
        HashSet<String> restrictedCookies = new HashSet<String>();
        for (Cookie cookie : this._cookies) {
            if (!cookie.mayBeSentTo(targetURL)) continue;
            restrictedCookies.add(cookie.getName());
            if (sb.length() != 0) {
                sb.append("; ");
            }
            sb.append(cookie.getName()).append('=').append(cookie.getValue());
        }
        for (Cookie cookie : this._globalCookies) {
            if (restrictedCookies.contains(cookie.getName())) continue;
            if (sb.length() != 0) {
                sb.append("; ");
            }
            sb.append(cookie.getName()).append('=').append(cookie.getValue());
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public void updateCookies(CookieJar newJar) {
        Iterator i = newJar._cookies.iterator();
        while (i.hasNext()) {
            this.addUniqueCookie((Cookie)i.next());
        }
    }

    void addUniqueCookie(Cookie cookie) {
        this._cookies.remove(cookie);
        this._cookies.add(cookie);
    }

    class CookiePress {
        private StringBuffer _value = new StringBuffer();
        private HashMap _attributes = new HashMap();
        private URL _sourceURL;

        public CookiePress(URL sourceURL) {
            this._sourceURL = sourceURL;
        }

        void clear() {
            this._value.setLength(0);
            this._attributes.clear();
        }

        void addToken(String token, char lastChar) {
            this._value.insert(0, token);
            if (lastChar != '=') {
                this._value.insert(0, ',');
            }
        }

        void addTokenWithEqualsSign(CookieRecipe recipe, String token, int equalsIndex) {
            String name = token.substring(0, equalsIndex).trim();
            String value = token.substring(equalsIndex + 1).trim();
            this._value.insert(0, value);
            if (recipe.isCookieAttribute(name.toLowerCase())) {
                this._attributes.put(name.toLowerCase(), this._value.toString());
            } else {
                this.addCookieIfValid(new Cookie(name, this._value.toString(), this._attributes));
                this._attributes.clear();
            }
            this._value.setLength(0);
        }

        private void addCookieIfValid(Cookie cookie) {
            if (this.acceptCookie(cookie)) {
                CookieJar.this.addUniqueCookie(cookie);
            }
        }

        private boolean acceptCookie(Cookie cookie) {
            int status;
            if (cookie.getPath() == null) {
                cookie.setPath(this.getParentPath(this._sourceURL.getPath()));
            } else {
                status = this.getPathAttributeStatus(cookie.getPath(), this._sourceURL.getPath());
                if (status != 0) {
                    this.reportCookieRejected(status, cookie.getPath(), cookie.getName());
                    return false;
                }
            }
            if (cookie.getDomain() == null) {
                cookie.setDomain(this._sourceURL.getHost());
            } else if (!CookieProperties.isDomainMatchingStrict() && cookie.getDomain().equalsIgnoreCase(this._sourceURL.getHost())) {
                cookie.setDomain(this._sourceURL.getHost());
            } else {
                status = this.getDomainAttributeStatus(cookie.getDomain(), this._sourceURL.getHost());
                if (status != 0) {
                    this.reportCookieRejected(status, cookie.getDomain(), cookie.getName());
                    return false;
                }
            }
            return true;
        }

        private String getParentPath(String path) {
            int rightmostSlashIndex = path.lastIndexOf(47);
            return rightmostSlashIndex < 0 ? "/" : path.substring(0, rightmostSlashIndex);
        }

        private int getPathAttributeStatus(String pathAttribute, String sourcePath) {
            if (!CookieProperties.isPathMatchingStrict() || sourcePath.length() == 0 || sourcePath.startsWith(pathAttribute)) {
                return 0;
            }
            return 5;
        }

        private int getDomainAttributeStatus(String domainAttribute, String sourceHost) {
            if (((String)domainAttribute).equals(sourceHost)) {
                return 0;
            }
            if (!((String)domainAttribute).startsWith(".")) {
                domainAttribute = "." + (String)domainAttribute;
            }
            if (((String)domainAttribute).lastIndexOf(46) == 0) {
                return 2;
            }
            if (!sourceHost.endsWith((String)domainAttribute)) {
                return 3;
            }
            if (CookieProperties.isDomainMatchingStrict() && sourceHost.lastIndexOf((String)domainAttribute) > sourceHost.indexOf(46)) {
                return 4;
            }
            return 0;
        }

        private boolean reportCookieRejected(int reason, String attribute, String source) {
            CookieProperties.reportCookieRejected(reason, attribute, source);
            return false;
        }
    }

    class RFC2109CookieRecipe
    extends CookieRecipe {
        RFC2109CookieRecipe() {
        }

        @Override
        protected boolean isCookieAttribute(String stringLowercase) {
            return stringLowercase.equals("path") || stringLowercase.equals("domain") || stringLowercase.equals("expires") || stringLowercase.equals("comment") || stringLowercase.equals("max-age") || stringLowercase.equals("version");
        }

        @Override
        protected boolean isCookieReservedWord(String token) {
            return token.equalsIgnoreCase("secure");
        }
    }

    abstract class CookieRecipe {
        CookieRecipe() {
        }

        void findCookies(String cookieHeader) {
            Vector tokens = this.getCookieTokens(cookieHeader);
            for (int i = tokens.size() - 1; i >= 0; --i) {
                String token = (String)tokens.elementAt(i);
                int equalsIndex = this.getEqualsIndex(token);
                if (equalsIndex != -1) {
                    CookieJar.this._press.addTokenWithEqualsSign(this, token, equalsIndex);
                    continue;
                }
                if (this.isCookieReservedWord(token)) {
                    CookieJar.this._press.clear();
                    continue;
                }
                CookieJar.this._press.addToken(token, this.lastCharOf(i == 0 ? "" : (String)tokens.elementAt(i - 1)));
            }
        }

        private char lastCharOf(String string) {
            return string.length() == 0 ? (char)' ' : string.charAt(string.length() - 1);
        }

        private int getEqualsIndex(String token) {
            if (!token.endsWith("==")) {
                return token.indexOf(61);
            }
            return this.getEqualsIndex(token.substring(0, token.length() - 2));
        }

        private Vector getCookieTokens(String cookieHeader) {
            StringReader sr = new StringReader(cookieHeader);
            StreamTokenizer st = new StreamTokenizer(sr);
            Vector<String> tokens = new Vector<String>();
            st.resetSyntax();
            st.wordChars(0, 65535);
            st.quoteChar(34);
            st.quoteChar(39);
            st.whitespaceChars(59, 59);
            st.whitespaceChars(44, 44);
            try {
                while (st.nextToken() != -1) {
                    Object tokenContent = st.sval;
                    if (((String)tokenContent).toLowerCase().startsWith("expires=") && st.nextToken() != -1) {
                        tokenContent = (String)tokenContent + "," + st.sval;
                    }
                    tokenContent = ((String)tokenContent).trim();
                    tokens.addElement((String)tokenContent);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sr.close();
            return tokens;
        }

        protected abstract boolean isCookieAttribute(String var1);

        protected abstract boolean isCookieReservedWord(String var1);
    }

    class RFC2965CookieRecipe
    extends CookieRecipe {
        RFC2965CookieRecipe() {
        }

        @Override
        protected boolean isCookieAttribute(String stringLowercase) {
            return stringLowercase.equals("path") || stringLowercase.equals("domain") || stringLowercase.equals("comment") || stringLowercase.equals("commenturl") || stringLowercase.equals("max-age") || stringLowercase.equals("version") || stringLowercase.equals("$version") || stringLowercase.equals("port");
        }

        @Override
        protected boolean isCookieReservedWord(String token) {
            return token.equalsIgnoreCase("discard") || token.equalsIgnoreCase("secure");
        }
    }
}

