/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AttrImpl;
import com.meterware.httpunit.dom.CDATASectionImpl;
import com.meterware.httpunit.dom.CommentImpl;
import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.NodeImpl;
import com.meterware.httpunit.dom.ProcessingInstructionImpl;
import com.meterware.httpunit.dom.TextImpl;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLElement;

public class DocumentImpl
extends NodeImpl
implements Document {
    private Element _documentElement;

    static DocumentImpl createDocument() {
        DocumentImpl document = new DocumentImpl();
        document.initialize();
        return document;
    }

    protected void initialize() {
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public Document getOwnerDocument() {
        return this;
    }

    @Override
    public DocumentType getDoctype() {
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return null;
    }

    @Override
    public Element getDocumentElement() {
        return this._documentElement;
    }

    void setDocumentElement(Element documentElement) {
        if (this._documentElement != null) {
            throw new IllegalStateException("A document may have only one root");
        }
        this._documentElement = documentElement;
        this.appendChild(documentElement);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return ElementImpl.createElement(this, tagName);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new UnsupportedOperationException("DocumentFragment creation not supported ");
    }

    @Override
    public Text createTextNode(String data) {
        return TextImpl.createText(this, data);
    }

    @Override
    public Comment createComment(String data) {
        return CommentImpl.createComment(this, data);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return CDATASectionImpl.createCDATASection(this, data);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return ProcessingInstructionImpl.createProcessingImpl(this, target, data);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return AttrImpl.createAttribute(this, name);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        throw new UnsupportedOperationException("EntityReference creation not supported ");
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        switch (importedNode.getNodeType()) {
            case 2: {
                return AttrImpl.importNode(this, (Attr)importedNode);
            }
            case 4: {
                return CDATASectionImpl.importNode(this, (CDATASection)importedNode);
            }
            case 8: {
                return CommentImpl.importNode(this, (Comment)importedNode);
            }
            case 1: {
                return ElementImpl.importNode(this, (Element)importedNode, deep);
            }
            case 7: {
                return ProcessingInstructionImpl.importNode(this, (ProcessingInstruction)importedNode);
            }
            case 3: {
                return TextImpl.importNode(this, (Text)importedNode);
            }
        }
        throw new DOMException(9, "Cannot import node type " + importedNode.getNodeType());
    }

    @Override
    public Element getElementById(String elementId) {
        Iterator each = this.preOrderIterator();
        while (each.hasNext()) {
            HTMLElement element;
            Node node = (Node)each.next();
            if (!(node instanceof HTMLElement) || !elementId.equals((element = (HTMLElement)node).getId())) continue;
            return element;
        }
        return null;
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return ElementImpl.createElement(this, namespaceURI, qualifiedName);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return AttrImpl.createAttribute(this, namespaceURI, qualifiedName);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (namespaceURI != null) {
            throw new UnsupportedOperationException("Namespaces are not supported");
        }
        return this.getElementsByTagName(localName);
    }

    void importChildren(Node original, Node copy) {
        NodeList children = original.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == -1) continue;
            Node childCopy = this.importNode(child, true);
            copy.appendChild(childCopy);
        }
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }
}

