/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.html.HTMLAnchorElement;

public class HTMLAnchorElementImpl
extends HTMLElementImpl
implements HTMLAnchorElement {
    @Override
    ElementImpl create() {
        return new HTMLAnchorElementImpl();
    }

    @Override
    public String getCharset() {
        return this.getAttributeWithNoDefault("charset");
    }

    @Override
    public String getHref() {
        String relativeLocation = this.getAttributeWithNoDefault("href");
        if (relativeLocation.indexOf(58) > 0 || relativeLocation.equals("#")) {
            return relativeLocation;
        }
        try {
            return new URL(((HTMLDocumentImpl)this.getOwnerDocument()).getBaseUrl(), relativeLocation).toExternalForm();
        }
        catch (MalformedURLException e) {
            return e.toString();
        }
    }

    @Override
    public String getHreflang() {
        return this.getAttributeWithNoDefault("hreflang");
    }

    @Override
    public String getRel() {
        return this.getAttributeWithNoDefault("rel");
    }

    @Override
    public String getRev() {
        return this.getAttributeWithNoDefault("rev");
    }

    @Override
    public String getTarget() {
        return this.getAttributeWithNoDefault("target");
    }

    @Override
    public String getType() {
        return this.getAttributeWithNoDefault("type");
    }

    @Override
    public void setCharset(String charset) {
        this.setAttribute("charset", charset);
    }

    @Override
    public void setHref(String href) {
        this.setAttribute("href", href);
    }

    @Override
    public void setHreflang(String hreflang) {
        this.setAttribute("hreflang", hreflang);
    }

    @Override
    public void setRel(String rel) {
        this.setAttribute("rel", rel);
    }

    @Override
    public void setRev(String rev) {
        this.setAttribute("rev", rev);
    }

    @Override
    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    @Override
    public void blur() {
        this.handleEvent("onblur");
    }

    @Override
    public void focus() {
        this.handleEvent("onfocus");
    }

    @Override
    public String getAccessKey() {
        return this.getAttributeWithNoDefault("accesskey");
    }

    @Override
    public String getCoords() {
        return this.getAttributeWithNoDefault("coords");
    }

    @Override
    public String getName() {
        return this.getAttributeWithNoDefault("name");
    }

    @Override
    public String getShape() {
        return this.getAttributeWithNoDefault("shape");
    }

    @Override
    public int getTabIndex() {
        return this.getIntegerAttribute("tabindex");
    }

    @Override
    public void setAccessKey(String accessKey) {
        this.setAttribute("accesskey", accessKey);
    }

    @Override
    public void setCoords(String coords) {
        this.setAttribute("coords", coords);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public void setShape(String shape) {
        this.setAttribute("shape", shape);
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.setAttribute("tabindex", tabIndex);
    }

    @Override
    public void doClickAction() {
        if (null == this.getHref() || this.getHref().startsWith("#")) {
            return;
        }
        try {
            ((HTMLDocumentImpl)this.getOwnerDocument()).getWindow().submitRequest(this, "GET", this.getHref(), this.getTarget(), new byte[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error clicking link: " + String.valueOf(e));
        }
    }
}

