/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.dom.ScriptingSupport;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;

public class HTMLCollectionImpl
extends ScriptableObject
implements HTMLCollection {
    private NodeList _list;

    public static HTMLCollectionImpl createHTMLCollectionImpl(NodeList list) {
        HTMLCollectionImpl htmlCollection = new HTMLCollectionImpl();
        htmlCollection.initialize(list);
        return htmlCollection;
    }

    private void initialize(NodeList list) {
        this._list = list;
    }

    @Override
    public int getLength() {
        return this._list.getLength();
    }

    @Override
    public Node item(int index) {
        return this._list.item(index);
    }

    @Override
    public Node namedItem(String name) {
        if (name == null) {
            return null;
        }
        Node nodeByName = null;
        for (int i = 0; null == nodeByName && i < this.getLength(); ++i) {
            Node node = this.item(i);
            if (!(node instanceof HTMLElementImpl)) continue;
            if (name.equalsIgnoreCase(((HTMLElement)node).getId())) {
                return node;
            }
            if (!name.equalsIgnoreCase(((HTMLElementImpl)node).getAttributeWithNoDefault("name"))) continue;
            nodeByName = node;
        }
        return nodeByName;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public Object get(String propertyName, Scriptable scriptable) {
        Object result = super.get(propertyName, scriptable);
        if (result != NOT_FOUND) {
            return result;
        }
        Object namedProperty = ScriptingSupport.getNamedProperty(this, propertyName, scriptable);
        if (namedProperty != NOT_FOUND) {
            return namedProperty;
        }
        Node namedItem = this.namedItem(propertyName);
        return namedItem == null ? NOT_FOUND : namedItem;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || index >= this._list.getLength()) {
            return NOT_FOUND;
        }
        return this.item(index);
    }
}

