/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLElement;

public class HTMLElementImpl
extends ElementImpl
implements HTMLElement {
    public static final String UNSPECIFIED_ATTRIBUTE = null;

    ElementImpl create() {
        return new HTMLElementImpl();
    }

    public void click() {
        this.doClickAction();
    }

    public void doClickAction() {
    }

    @Override
    public String getId() {
        return this.getAttributeWithNoDefault("id");
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    @Override
    public String getTitle() {
        return this.getAttributeWithNoDefault("title");
    }

    @Override
    public void setTitle(String title) {
        this.setAttribute("title", title);
    }

    @Override
    public String getLang() {
        return this.getAttributeWithNoDefault("lang");
    }

    @Override
    public void setLang(String lang) {
        this.setAttribute("lang", lang);
    }

    @Override
    public String getDir() {
        return this.getAttributeWithNoDefault("dir");
    }

    @Override
    public void setDir(String dir) {
        this.setAttribute("dir", dir);
    }

    @Override
    public String getClassName() {
        return this.getAttributeWithNoDefault("class");
    }

    @Override
    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        return super.getElementsByTagName(((HTMLDocumentImpl)this.getOwnerDocument()).toNodeCase(name));
    }

    protected final String getAttributeWithDefault(String attributeName, String defaultValue) {
        if (this.hasAttribute(attributeName)) {
            return this.getAttribute(attributeName);
        }
        return defaultValue;
    }

    protected final String getAttributeWithNoDefault(String attributeName) {
        if (this.hasAttribute(attributeName)) {
            return this.getAttribute(attributeName);
        }
        return UNSPECIFIED_ATTRIBUTE;
    }

    protected boolean getBooleanAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr != null && !attr.getValue().equalsIgnoreCase("false");
    }

    protected int getIntegerAttribute(String name) {
        String value = this.getAttribute(name);
        return value.length() == 0 ? 0 : Integer.parseInt(value);
    }

    protected int getIntegerAttribute(String name, int defaultValue) {
        String value = this.getAttribute(name);
        return value.length() == 0 ? defaultValue : Integer.parseInt(value);
    }

    protected void setAttribute(String name, boolean disabled) {
        this.setAttribute(name, disabled ? "true" : "false");
    }

    protected void setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
    }

    HTMLDocumentImpl getHtmlDocument() {
        return (HTMLDocumentImpl)this.getOwnerDocument();
    }
}

