/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AttrImpl;
import com.meterware.httpunit.dom.DomWindow;
import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLCollectionImpl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.dom.NodeListImpl;
import com.meterware.httpunit.protocol.URLEncodedString;
import com.meterware.httpunit.scripting.FormScriptable;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFormElement;

public class HTMLFormElementImpl
extends HTMLElementImpl
implements HTMLFormElement,
FormScriptable {
    @Override
    ElementImpl create() {
        return new HTMLFormElementImpl();
    }

    @Override
    public Object get(String propertyName, Scriptable scriptable) {
        HTMLCollection elements = this.getElements();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            NamedNodeMap attributes = node.getAttributes();
            AttrImpl nameAttribute = (AttrImpl)attributes.getNamedItem("name");
            if (nameAttribute != null && propertyName.equals(nameAttribute.getValue())) {
                return node;
            }
            AttrImpl idAttribute = (AttrImpl)attributes.getNamedItem("id");
            if (idAttribute == null || !propertyName.equals(idAttribute.getValue())) continue;
            return node;
        }
        return super.get(propertyName, scriptable);
    }

    @Override
    public String getAcceptCharset() {
        return this.getAttributeWithDefault("accept-charset", "UNKNOWN");
    }

    @Override
    public void setAcceptCharset(String acceptCharset) {
        this.setAttribute("accept-charset", acceptCharset);
    }

    @Override
    public String getAction() {
        return this.getAttribute("action");
    }

    @Override
    public void setAction(String action) {
        this.setAttribute("action", action);
    }

    @Override
    public void setParameterValue(String name, String value) {
        Object control = this.get(name, null);
        if (control instanceof ScriptableObject) {
            ((ScriptableObject)control).put("value", (Scriptable)this, (Object)value);
        }
    }

    @Override
    public String getEnctype() {
        return this.getAttributeWithDefault("enctype", "application/x-www-form-urlencoded");
    }

    @Override
    public void setEnctype(String enctype) {
        this.setAttribute("enctype", enctype);
    }

    @Override
    public String getMethod() {
        return this.getAttributeWithDefault("method", "get");
    }

    @Override
    public void setMethod(String method) {
        this.setAttribute("method", method);
    }

    @Override
    public String getName() {
        String result = this.getAttributeWithNoDefault("name");
        if (result == null) {
            result = this.getId();
        }
        return result;
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getTarget() {
        return this.getAttributeWithNoDefault("target");
    }

    @Override
    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    @Override
    public HTMLCollection getElements() {
        Node node;
        ArrayList<Node> elements = new ArrayList<Node>();
        String[] names = new String[]{"INPUT", "TEXTAREA", "BUTTON", "SELECT"};
        Iterator each = this.preOrderIteratorAfterNode();
        while (each.hasNext() && !((node = (Node)each.next()) instanceof HTMLFormElement)) {
            if (node.getNodeType() != 1) continue;
            String tagName = ((Element)node).getTagName();
            for (int i = 0; i < names.length; ++i) {
                if (!tagName.equalsIgnoreCase(names[i])) continue;
                elements.add(node);
            }
        }
        return HTMLCollectionImpl.createHTMLCollectionImpl(new NodeListImpl(elements));
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void reset() {
        HTMLCollection elements = this.getElements();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof HTMLControl)) continue;
            ((HTMLControl)node).reset();
        }
    }

    @Override
    public void submit() {
        this.doSubmitAction();
    }

    void doSubmitAction() {
        try {
            if ("get".equalsIgnoreCase(this.getMethod())) {
                this.getDomWindow().submitRequest(this, this.getMethod(), this.getEffectiveUrl(), this.getTarget(), new byte[0]);
            } else if ("post".equalsIgnoreCase(this.getMethod())) {
                this.getDomWindow().submitRequest(this, this.getMethod(), this.getAction(), this.getTarget(), new byte[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error submitting form: " + String.valueOf(e));
        }
        finally {
            this.silenceSubmitButtons();
        }
    }

    private void silenceSubmitButtons() {
        HTMLCollection controls = this.getElements();
        for (int i = 0; i < controls.getLength(); ++i) {
            ((HTMLControl)controls.item(i)).silenceSubmitButton();
        }
    }

    private String getEffectiveUrl() throws IOException {
        StringBuffer spec = new StringBuffer(this.getAction());
        if ("get".equalsIgnoreCase(this.getMethod())) {
            URLEncodedString parameters = new URLEncodedString();
            HTMLCollection controls = this.getElements();
            for (int i = 0; i < controls.getLength(); ++i) {
                ((HTMLControl)controls.item(i)).addValues(parameters, "us-ascii");
            }
            if (spec.indexOf("?") >= 0 && !spec.toString().endsWith("?")) {
                spec.append('&');
            } else {
                spec.append('?');
            }
            spec.append(parameters.getString());
        }
        return new URL(this.getDomWindow().getUrl(), spec.toString()).toExternalForm();
    }

    private DomWindow getDomWindow() {
        return ((HTMLDocumentImpl)this.getOwnerDocument()).getWindow();
    }
}

