/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLElementImpl;
import com.meterware.httpunit.dom.HTMLFormElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLInputElement;

public class HTMLInputElementImpl
extends HTMLControl
implements HTMLInputElement {
    private String _value;
    private Boolean _checked;
    private TypeSpecificBehavior _behavior;

    @Override
    ElementImpl create() {
        return new HTMLInputElementImpl();
    }

    @Override
    public void blur() {
        this.handleEvent("onblur");
    }

    @Override
    public void focus() {
        this.handleEvent("onfocus");
    }

    @Override
    public void doClickAction() {
        this.getBehavior().click();
    }

    @Override
    public void select() {
    }

    @Override
    public String getAccept() {
        return this.getAttributeWithNoDefault("accept");
    }

    @Override
    public String getAccessKey() {
        return this.getAttributeWithNoDefault("accessKey");
    }

    @Override
    public String getAlign() {
        return this.getAttributeWithDefault("align", "bottom");
    }

    @Override
    public String getAlt() {
        return this.getAttributeWithNoDefault("alt");
    }

    @Override
    public boolean getChecked() {
        return this.getBehavior().getChecked();
    }

    @Override
    public boolean getDefaultChecked() {
        return this.getBooleanAttribute("checked");
    }

    @Override
    public String getDefaultValue() {
        return this.getAttributeWithNoDefault("value");
    }

    @Override
    public int getMaxLength() {
        return this.getIntegerAttribute("maxlength");
    }

    @Override
    public String getSize() {
        return this.getAttributeWithNoDefault("size");
    }

    @Override
    public String getSrc() {
        return this.getAttributeWithNoDefault("src");
    }

    @Override
    public String getUseMap() {
        return this.getAttributeWithNoDefault("useMap");
    }

    @Override
    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    @Override
    public void setAccessKey(String accessKey) {
        this.setAttribute("accessKey", accessKey);
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    @Override
    public void setChecked(boolean checked) {
        this.getBehavior().setChecked(checked);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.setAttribute("checked", defaultChecked);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setAttribute("value", defaultValue);
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.setAttribute("maxlength", maxLength);
    }

    @Override
    public void setSize(String size) {
        this.setAttribute("size", size);
    }

    @Override
    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    @Override
    public void setUseMap(String useMap) {
        this.setAttribute("useMap", useMap);
    }

    @Override
    public String getValue() {
        return this.getBehavior().getValue();
    }

    @Override
    public void setValue(String value) {
        this.getBehavior().setValue(value);
    }

    @Override
    public void reset() {
        this.getBehavior().reset();
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        super.setAttribute(name, value);
        if (name.equalsIgnoreCase("type")) {
            this.selectBehavior(this.getType().toLowerCase());
        }
    }

    @Override
    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        this.getBehavior().addValues(this.getName(), processor, characterSet);
    }

    @Override
    public void silenceSubmitButton() {
        this.getBehavior().silenceSubmitButton();
    }

    void setState(boolean checked) {
        this._checked = checked ? Boolean.TRUE : Boolean.FALSE;
    }

    static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private void selectBehavior(String type) {
        this._behavior = type == null || type.equals("text") || type.equals("password") || type.equals("hidden") ? new EditableTextBehavior(this) : (type.equals("checkbox") ? new CheckboxBehavior(this) : (type.equals("radio") ? new RadioButtonBehavior(this) : (type.equals("reset") ? new ResetButtonBehavior(this) : (type.equals("submit") ? new SubmitButtonBehavior(this) : new DefaultBehavior(this)))));
    }

    private TypeSpecificBehavior getBehavior() {
        if (this._behavior == null) {
            this.selectBehavior(this.getType().toLowerCase());
        }
        return this._behavior;
    }

    static interface TypeSpecificBehavior {
        public void setValue(String var1);

        public String getValue();

        public void reset();

        public void click();

        public boolean getChecked();

        public void setChecked(boolean var1);

        public void addValues(String var1, ParameterProcessor var2, String var3) throws IOException;

        public void silenceSubmitButton();
    }

    class EditableTextBehavior
    extends DefaultBehavior {
        public EditableTextBehavior(HTMLElementImpl element) {
            super(element);
        }

        @Override
        public void reset() {
            HTMLInputElementImpl.this._value = null;
        }
    }

    class CheckboxBehavior
    extends DefaultBehavior {
        public CheckboxBehavior(HTMLElementImpl element) {
            super(element);
        }

        @Override
        public boolean getChecked() {
            return HTMLInputElementImpl.this._checked != null ? HTMLInputElementImpl.this._checked.booleanValue() : HTMLInputElementImpl.this.getDefaultChecked();
        }

        @Override
        public void setChecked(boolean checked) {
            HTMLInputElementImpl.this.setState(checked);
        }

        @Override
        public void reset() {
            HTMLInputElementImpl.this._checked = null;
        }

        @Override
        public void click() {
            this.setChecked(!this.getChecked());
        }

        @Override
        public void addValues(String name, ParameterProcessor processor, String characterSet) throws IOException {
            if (!HTMLInputElementImpl.this.getDisabled() && this.getChecked()) {
                processor.addParameter(name, this.getFormValue(), characterSet);
            }
        }

        private String getFormValue() {
            return HTMLInputElementImpl.this._value == null ? "on" : HTMLInputElementImpl.this._value;
        }
    }

    class RadioButtonBehavior
    extends CheckboxBehavior {
        public RadioButtonBehavior(HTMLElementImpl element) {
            super(element);
        }

        @Override
        public void setChecked(boolean checked) {
            if (checked) {
                HTMLCollection elements = HTMLInputElementImpl.this.getForm().getElements();
                for (int i = 0; i < elements.getLength(); ++i) {
                    Node node = elements.item(i);
                    if (!(node instanceof HTMLInputElementImpl)) continue;
                    HTMLInputElementImpl input = (HTMLInputElementImpl)node;
                    if (!HTMLInputElementImpl.this.getName().equals(input.getName()) || !input.getType().equalsIgnoreCase("radio")) continue;
                    input.setState(false);
                }
            }
            HTMLInputElementImpl.this.setState(checked);
        }

        @Override
        public void click() {
            this.setChecked(true);
        }
    }

    class ResetButtonBehavior
    extends DefaultBehavior {
        public ResetButtonBehavior(HTMLElementImpl element) {
            super(element);
        }

        @Override
        public void click() {
            HTMLInputElementImpl.this.getForm().reset();
        }
    }

    class SubmitButtonBehavior
    extends DefaultBehavior {
        private boolean _sendWithSubmit;

        public SubmitButtonBehavior(HTMLElementImpl element) {
            super(element);
        }

        @Override
        public void click() {
            this._sendWithSubmit = true;
            ((HTMLFormElementImpl)HTMLInputElementImpl.this.getForm()).doSubmitAction();
        }

        @Override
        public void addValues(String name, ParameterProcessor processor, String characterSet) throws IOException {
            if (!this._sendWithSubmit) {
                return;
            }
            super.addValues(name, processor, characterSet);
        }

        @Override
        public void silenceSubmitButton() {
            this._sendWithSubmit = false;
        }
    }

    class DefaultBehavior
    implements TypeSpecificBehavior {
        private HTMLElementImpl _element;

        public DefaultBehavior(HTMLElementImpl element) {
            this._element = element;
        }

        @Override
        public String getValue() {
            return HTMLInputElementImpl.this._value != null ? HTMLInputElementImpl.this._value : HTMLInputElementImpl.this.getDefaultValue();
        }

        @Override
        public void setValue(String value) {
            if (HTMLInputElementImpl.equals(value, HTMLInputElementImpl.this._value)) {
                return;
            }
            HTMLInputElementImpl.this._value = value;
            this.reportPropertyChanged("value");
        }

        @Override
        public boolean getChecked() {
            return HTMLInputElementImpl.this.getDefaultChecked();
        }

        @Override
        public void setChecked(boolean checked) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void click() {
        }

        protected void reportPropertyChanged(String propertyName) {
            this._element.reportPropertyChanged(propertyName);
        }

        @Override
        public void addValues(String name, ParameterProcessor processor, String characterSet) throws IOException {
            processor.addParameter(name, this.getValue(), characterSet);
        }

        @Override
        public void silenceSubmitButton() {
        }
    }
}

