/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AbstractDomComponent;
import com.meterware.httpunit.dom.DocumentImpl;
import com.meterware.httpunit.dom.NodeListImpl;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.html.HTMLIFrameElement;

public abstract class NodeImpl
extends AbstractDomComponent
implements Node {
    private DocumentImpl _ownerDocument;
    private NodeImpl _parentNode;
    private NodeImpl _firstChild;
    private NodeImpl _nextSibling;
    private NodeImpl _previousSibling;
    private Hashtable _userData = new Hashtable();
    static IteratorMask SKIP_IFRAMES = new IteratorMask(){

        @Override
        public boolean skipSubtree(Node subtreeRoot) {
            return subtreeRoot instanceof HTMLIFrameElement;
        }
    };

    protected void initialize(DocumentImpl ownerDocument) {
        if (this._ownerDocument != null) {
            throw new IllegalStateException("NodeImpl already initialized");
        }
        if (ownerDocument == null) {
            throw new IllegalArgumentException("No owner document specified");
        }
        this._ownerDocument = ownerDocument;
    }

    @Override
    public Node getParentNode() {
        return this._parentNode;
    }

    @Override
    public NodeList getChildNodes() {
        ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
        NodeImpl child = this._firstChild;
        while (child != null) {
            list.add(child);
            child = child._nextSibling;
        }
        return new NodeListImpl(list);
    }

    @Override
    public Node getFirstChild() {
        return this._firstChild;
    }

    @Override
    public Node getLastChild() {
        if (this._firstChild == null) {
            return null;
        }
        Node child = this._firstChild;
        while (child.getNextSibling() != null) {
            child = child.getNextSibling();
        }
        return child;
    }

    @Override
    public Node getPreviousSibling() {
        return this._previousSibling;
    }

    @Override
    public Node getNextSibling() {
        return this._nextSibling;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return this._ownerDocument;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        NodeImpl refChildNode = (NodeImpl)refChild;
        if (refChildNode.getParentNode() != this) {
            throw new DOMException(8, "Must specify an existing child as the reference");
        }
        NodeImpl newChildNode = this.getChildIfPermitted(newChild);
        this.removeFromTree(newChildNode);
        newChildNode._parentNode = this;
        if (refChildNode._previousSibling == null) {
            this._firstChild = newChildNode;
        } else {
            refChildNode._previousSibling.setNextSibling(newChildNode);
        }
        newChildNode.setNextSibling(refChildNode);
        return newChildNode;
    }

    private void removeFromTree(NodeImpl childNode) {
        if (childNode._parentNode != null) {
            if (childNode._previousSibling != null) {
                childNode._previousSibling.setNextSibling(childNode._nextSibling);
            } else {
                childNode._parentNode._firstChild = childNode._nextSibling;
                childNode._nextSibling._previousSibling = null;
            }
            childNode._parentNode = null;
        }
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.insertBefore(newChild, oldChild);
        return this.removeChild(oldChild);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getParentNode() != this) {
            throw new DOMException(8, "May only remove a node from its own parent");
        }
        this.removeFromTree((NodeImpl)oldChild);
        return oldChild;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild == null) {
            throw new IllegalArgumentException("child to append may not be null");
        }
        NodeImpl childNode = this.getChildIfPermitted(newChild);
        this.removeFromTree(childNode);
        childNode._parentNode = this;
        if (this._firstChild == null) {
            this._firstChild = childNode;
        } else {
            ((NodeImpl)this.getLastChild()).setNextSibling(childNode);
        }
        return newChild;
    }

    protected NodeImpl getChildIfPermitted(Node proposedChild) {
        if (!(proposedChild instanceof NodeImpl)) {
            throw new DOMException(4, "Specified node is from a different DOM implementation");
        }
        NodeImpl childNode = (NodeImpl)proposedChild;
        if (this.getOwnerDocument() != childNode._ownerDocument) {
            throw new DOMException(4, "Specified node is from a different document");
        }
        for (Node parent = this; parent != null; parent = parent.getParentNode()) {
            if (proposedChild != parent) continue;
            throw new DOMException(3, "May not add node as its own descendant");
        }
        return childNode;
    }

    private void setNextSibling(NodeImpl sibling) {
        this._nextSibling = sibling;
        if (sibling != null) {
            sibling._previousSibling = this;
        }
    }

    @Override
    public boolean hasChildNodes() {
        return this._firstChild != null;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.getOwnerDocument().importNode(this, deep);
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this._userData.put(key, data);
    }

    @Override
    public Object getUserData(String key) {
        return this._userData.get(key);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public NodeList getElementsByTagName(String name) {
        ArrayList matchingElements = new ArrayList();
        this.appendElementsWithTag(name, matchingElements);
        return new NodeListImpl(matchingElements);
    }

    private void appendElementsWithTag(String name, ArrayList matchingElements) {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (name.equals("*") || ((Element)child).getTagName().equalsIgnoreCase(name)) {
                matchingElements.add(child);
            }
            ((NodeImpl)child).appendElementsWithTag(name, matchingElements);
        }
    }

    protected NodeList getElementsByTagNames(String[] names) {
        ArrayList matchingElements = new ArrayList();
        this.appendElementsWithTags(names, matchingElements);
        return new NodeListImpl(matchingElements);
    }

    void appendElementsWithTags(String[] names, ArrayList matchingElements) {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String tagName = ((Element)child).getTagName();
            for (int i = 0; i < names.length; ++i) {
                if (!tagName.equalsIgnoreCase(names[i])) continue;
                matchingElements.add(child);
            }
            ((NodeImpl)child).appendElementsWithTags(names, matchingElements);
        }
    }

    String asText() {
        StringBuffer sb = new StringBuffer();
        this.appendContents(sb);
        return sb.toString();
    }

    void appendContents(StringBuffer sb) {
        NodeList nl = this.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            ((NodeImpl)nl.item(i)).appendContents(sb);
        }
    }

    public Iterator preOrderIterator() {
        return new PreOrderIterator(this);
    }

    public Iterator preOrderIterator(IteratorMask mask) {
        return new PreOrderIterator(this, mask);
    }

    public Iterator preOrderIteratorAfterNode() {
        return new PreOrderIterator(PreOrderIterator.nextNode(this));
    }

    public Iterator preOrderIteratorAfterNode(IteratorMask mask) {
        return new PreOrderIterator(PreOrderIterator.nextNode(this), mask);
    }

    @Override
    protected String getJavaPropertyName(String propertyName) {
        if (propertyName.equals("document")) {
            return "ownerDocument";
        }
        return propertyName;
    }

    static class PreOrderIterator
    implements Iterator {
        private NodeImpl _nextNode;
        private IteratorMask _mask;

        PreOrderIterator(NodeImpl currentNode) {
            this._nextNode = currentNode;
        }

        PreOrderIterator(NodeImpl currentNode, IteratorMask mask) {
            this(currentNode);
            this._mask = mask;
        }

        @Override
        public boolean hasNext() {
            return null != this._nextNode;
        }

        public Object next() {
            NodeImpl currentNode = this._nextNode;
            this._nextNode = PreOrderIterator.nextNode(this._nextNode);
            while (this._mask != null && this._nextNode != null && this._mask.skipSubtree(this._nextNode)) {
                this._nextNode = PreOrderIterator.nextSubtree(this._nextNode);
            }
            return currentNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static NodeImpl nextNode(NodeImpl node) {
            if (node._firstChild != null) {
                return node._firstChild;
            }
            return PreOrderIterator.nextSubtree(node);
        }

        private static NodeImpl nextSubtree(NodeImpl node) {
            if (node._nextSibling != null) {
                return node._nextSibling;
            }
            while (node._parentNode != null) {
                node = node._parentNode;
                if (node._nextSibling == null) continue;
                return node._nextSibling;
            }
            return null;
        }
    }

    static interface IteratorMask {
        public boolean skipSubtree(Node var1);
    }
}

