/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AbstractDomComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;

class ScriptingSupport {
    private static final Method NO_SUCH_PROPERTY = ScriptingSupport.class.getDeclaredMethods()[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static Hashtable _classFunctionMaps = new Hashtable();
    private static Hashtable _classGetterMaps = new Hashtable();
    private static Hashtable _classSetterMaps = new Hashtable();

    ScriptingSupport() {
    }

    static boolean hasNamedProperty(Object element, String javaPropertyName, Scriptable scriptable) {
        Method getter = ScriptingSupport.getPropertyGetter(element.getClass(), javaPropertyName);
        if (getter != NO_SUCH_PROPERTY) {
            return true;
        }
        FunctionObject function = ScriptingSupport.getFunctionObject(element.getClass(), javaPropertyName, scriptable);
        return function != null;
    }

    static Object getNamedProperty(Object element, String javaPropertyName, Scriptable scriptable) {
        Method getter = ScriptingSupport.getPropertyGetter(element.getClass(), javaPropertyName);
        if (getter == NO_SUCH_PROPERTY) {
            FunctionObject function = ScriptingSupport.getFunctionObject(element.getClass(), javaPropertyName, scriptable);
            return function == null ? Scriptable.NOT_FOUND : function;
        }
        try {
            return getter.invoke(element, NO_ARGS);
        }
        catch (IllegalAccessException e) {
            return Scriptable.NOT_FOUND;
        }
        catch (InvocationTargetException e) {
            return Scriptable.NOT_FOUND;
        }
    }

    private static FunctionObject getFunctionObject(Class aClass, String methodName, Scriptable scriptable) {
        Object result;
        Hashtable<String, Object> functionMap = (Hashtable<String, Object>)_classFunctionMaps.get(aClass);
        if (functionMap == null) {
            functionMap = new Hashtable<String, Object>();
            _classFunctionMaps.put(aClass, functionMap);
        }
        if ((result = functionMap.get(methodName)) == NO_SUCH_PROPERTY) {
            return null;
        }
        if (result != null) {
            return (FunctionObject)result;
        }
        Method[] methods = aClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            FunctionObject function = new FunctionObject(methodName, (Member)method, scriptable);
            functionMap.put(methodName, function);
            return function;
        }
        functionMap.put(methodName, NO_SUCH_PROPERTY);
        return null;
    }

    private static Method getPropertyGetter(Class aClass, String propertyName) {
        Method result;
        Hashtable<String, Method> methodMap = (Hashtable<String, Method>)_classGetterMaps.get(aClass);
        if (methodMap == null) {
            methodMap = new Hashtable<String, Method>();
            _classGetterMaps.put(aClass, methodMap);
        }
        if ((result = (Method)methodMap.get(propertyName)) != null) {
            return result;
        }
        Method[] methods = aClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length > 0 || !method.getName().equalsIgnoreCase("is" + propertyName) && !method.getName().equalsIgnoreCase("get" + propertyName)) continue;
            methodMap.put(propertyName, method);
            return method;
        }
        methodMap.put(propertyName, NO_SUCH_PROPERTY);
        return NO_SUCH_PROPERTY;
    }

    static void setNamedProperty(AbstractDomComponent element, String javaPropertyName, Object value) {
        Method setter = ScriptingSupport.getPropertySetter(element.getClass(), javaPropertyName, value);
        if (setter == NO_SUCH_PROPERTY) {
            return;
        }
        try {
            setter.invoke((Object)element, ScriptingSupport.adjustedForSetter(value, setter));
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static Object adjustedForSetter(Object value, Method setter) {
        if (value == null) {
            return null;
        }
        Class<?> targetValueClass = setter.getParameterTypes()[0];
        if (targetValueClass.equals(String.class)) {
            return value.toString();
        }
        if (!(value instanceof Number) || !ScriptingSupport.isNumericParameter(targetValueClass)) {
            return value;
        }
        if (targetValueClass.getName().equals("int")) {
            return ((Number)value).intValue();
        }
        if (targetValueClass.getName().equals("byte")) {
            return ((Number)value).byteValue();
        }
        if (targetValueClass.getName().equals("long")) {
            return ((Number)value).longValue();
        }
        if (targetValueClass.getName().equals("short")) {
            return ((Number)value).shortValue();
        }
        if (targetValueClass.getName().equals("float")) {
            return Float.valueOf(((Number)value).intValue());
        }
        if (targetValueClass.getName().equals("double")) {
            return (double)((Number)value).intValue();
        }
        return value;
    }

    static Method getPropertySetter(Class aClass, String propertyName, Object value) {
        Method result;
        Hashtable<String, Method> methodMap = (Hashtable<String, Method>)_classSetterMaps.get(aClass);
        if (methodMap == null) {
            methodMap = new Hashtable<String, Method>();
            _classSetterMaps.put(aClass, methodMap);
        }
        if ((result = (Method)methodMap.get(propertyName)) != null) {
            return result;
        }
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method[] methods = aClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(setterName) || method.getParameterTypes().length != 1 || !ScriptingSupport.isConvertableTo(value.getClass(), method.getParameterTypes()[0])) continue;
            methodMap.put(propertyName, method);
            return method;
        }
        methodMap.put(propertyName, NO_SUCH_PROPERTY);
        return NO_SUCH_PROPERTY;
    }

    public static boolean isConvertableTo(Class valueType, Class parameterType) {
        if (valueType.equals(parameterType)) {
            return true;
        }
        if (parameterType.equals(String.class)) {
            return true;
        }
        if (valueType.equals(String.class) && ScriptingSupport.isNumericParameter(parameterType)) {
            return true;
        }
        if (Number.class.isAssignableFrom(valueType) && ScriptingSupport.isNumericParameter(parameterType)) {
            return true;
        }
        if (valueType.equals(Boolean.class) && parameterType.equals(Boolean.TYPE)) {
            return true;
        }
        return valueType.equals(String.class) && parameterType.equals(Boolean.class);
    }

    private static boolean isNumericParameter(Class parameterType) {
        if (parameterType.isPrimitive() && !parameterType.equals(Boolean.TYPE)) {
            return true;
        }
        return Number.class.isAssignableFrom(parameterType);
    }
}

