/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.HTMLParser;

public abstract class HTMLParserFactory {
    private static HTMLParser _jsoupParser = HTMLParserFactory.loadParserIfSupported("org.jsoup.parser.Parser", "com.meterware.httpunit.parsing.JSoupHTMLParser");
    private static HTMLParser _htmlParser;
    private static boolean _preserveTagCase;
    private static boolean _returnHTMLDocument;
    private static boolean _parserWarningsEnabled;
    private static boolean _forceUpper;
    private static boolean _forceLower;

    public static void reset() {
        _preserveTagCase = false;
        _returnHTMLDocument = true;
        _parserWarningsEnabled = false;
        _htmlParser = null;
        _forceUpper = false;
        _forceLower = false;
    }

    public static void useJTidyParser() {
        if (_jsoupParser == null) {
            throw new RuntimeException("JTidy parser not available");
        }
        _htmlParser = _jsoupParser;
    }

    public static void setHTMLParser(HTMLParser htmlParser) {
        _htmlParser = htmlParser;
    }

    public static HTMLParser getHTMLParser() {
        if (_htmlParser == null) {
            if (_jsoupParser != null) {
                _htmlParser = _jsoupParser;
            } else {
                throw new RuntimeException("No HTML parser found. Make sure that either nekoHTML.jar or Tidy.jar is in the in classpath");
            }
        }
        return _htmlParser;
    }

    public static boolean isPreserveTagCase() {
        return _preserveTagCase && HTMLParserFactory.getHTMLParser().supportsPreserveTagCase();
    }

    public static void setPreserveTagCase(boolean preserveTagCase) {
        _preserveTagCase = preserveTagCase;
        if (preserveTagCase) {
            _forceLower = false;
            _forceUpper = false;
        }
    }

    public static boolean isReturnHTMLDocument() {
        return _returnHTMLDocument && !HTMLParserFactory.isPreserveTagCase() && HTMLParserFactory.getHTMLParser().supportsReturnHTMLDocument();
    }

    public static void setReturnHTMLDocument(boolean returnHTMLDocument) {
        _returnHTMLDocument = returnHTMLDocument;
        if (returnHTMLDocument) {
            _preserveTagCase = false;
            _forceLower = false;
            _forceUpper = false;
        }
    }

    public static void setForceUpperCase(boolean forceUpper) {
        _forceUpper = forceUpper;
        if (_forceUpper) {
            _forceLower = false;
            _preserveTagCase = false;
        }
    }

    public static boolean getForceUpperCase() {
        return _forceUpper && HTMLParserFactory.getHTMLParser().supportsPreserveTagCase();
    }

    public static void setForceLowerCase(boolean forceLower) {
        _forceLower = forceLower;
        if (_forceLower) {
            _forceUpper = false;
            _preserveTagCase = false;
        }
    }

    public static boolean getForceLowerCase() {
        return _forceLower && HTMLParserFactory.getHTMLParser().supportsPreserveTagCase();
    }

    public static boolean isParserWarningsEnabled() {
        return _parserWarningsEnabled && HTMLParserFactory.getHTMLParser().supportsParserWarnings();
    }

    public static void setParserWarningsEnabled(boolean enabled) {
        _parserWarningsEnabled = enabled;
    }

    private static HTMLParser loadParserIfSupported(String testClassName, String parserClassName) {
        try {
            Class.forName(testClassName);
            return (HTMLParser)Class.forName(parserClassName).newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static {
        HTMLParserFactory.reset();
    }
}

