/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.dom.HTMLDocumentImpl;
import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.HTMLParser;
import com.meterware.httpunit.parsing.HTMLParserListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.Parser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class JSoupHTMLParser
implements HTMLParser {
    static final int MAX_ERRORS = 128;
    private static final char NBSP = '\u00a0';
    private static final String UTF_ENCODING = "UTF-8";

    JSoupHTMLParser() {
    }

    @Override
    public void parse(URL pageURL, String pageText, HTMLParserListener listener, DocumentAdapter adapter) throws IOException, SAXException {
        Parser htmlParser = Parser.htmlParser();
        Parser xmlParser = Parser.xmlParser();
        try {
            Document jsoupDocument;
            try {
                jsoupDocument = this.tryParserToEncode(htmlParser, pageURL, pageText);
                if (htmlParser.getErrors().size() > 0) {
                    jsoupDocument = this.tryParserToEncode(xmlParser, pageURL, pageText);
                }
                this.createHTMLDocument(jsoupDocument, adapter);
            }
            catch (RuntimeException | SAXException e) {
                jsoupDocument = this.tryParserToEncode(xmlParser, pageURL, pageText);
                this.createHTMLDocument(jsoupDocument, adapter);
            }
            if (listener != null) {
                String[] indices;
                for (ParseError error : htmlParser.getErrors()) {
                    indices = error.getCursorPos().split(":");
                    listener.error(pageURL, error.getErrorMessage(), Integer.valueOf(indices[0]), Integer.valueOf(indices[1]));
                }
                htmlParser.getErrors().clear();
                for (ParseError error : xmlParser.getErrors()) {
                    indices = error.getCursorPos().split(":");
                    listener.error(pageURL, error.getErrorMessage(), Integer.valueOf(indices[0]), Integer.valueOf(indices[1]));
                }
                xmlParser.getErrors().clear();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding failed");
        }
    }

    private Document tryParserToEncode(Parser jsoupParser, URL pageURL, String pageText) throws IllegalStateException, IOException, SAXException {
        jsoupParser.setTrackErrors(128);
        Document jsoupDocument = Jsoup.parse((InputStream)new ByteArrayInputStream(pageText.getBytes(UTF_ENCODING)), (String)UTF_ENCODING, (String)pageURL.getPath(), (Parser)jsoupParser);
        return jsoupDocument;
    }

    private void createHTMLDocument(Document jsoupDocument, DocumentAdapter adapter) throws IllegalStateException, IOException, SAXException {
        W3CDom w3cDom = new W3CDom();
        org.w3c.dom.Document w3cDoc = w3cDom.fromJsoup(jsoupDocument);
        HTMLDocumentImpl htmlDocument = new HTMLDocumentImpl();
        NodeList nl = w3cDoc.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node importedNode = nl.item(i);
            if (importedNode.getNodeType() == 10 || importedNode.getNodeType() == -1) continue;
            htmlDocument.appendChild(htmlDocument.importNode(importedNode, true));
        }
        adapter.setDocument(htmlDocument);
    }

    @Override
    public String getCleanedText(String string) {
        return string == null ? "" : string.replace('\u00a0', ' ');
    }

    @Override
    public boolean supportsPreserveTagCase() {
        return false;
    }

    @Override
    public boolean supportsForceTagCase() {
        return false;
    }

    @Override
    public boolean supportsReturnHTMLDocument() {
        return true;
    }

    @Override
    public boolean supportsParserWarnings() {
        return false;
    }
}

