/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.protocol;

import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.protocol.UploadFileSpec;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLEncodedString
implements ParameterProcessor {
    public static final int DEFAULT_BUFFER_SIZE = 128;
    private StringBuffer _buffer = new StringBuffer(128);
    private boolean _haveParameters = false;

    public String getString() {
        return this._buffer.toString();
    }

    @Override
    public void addParameter(String name, String value, String characterSet) {
        if (this._haveParameters) {
            this._buffer.append('&');
        }
        this._buffer.append(this.encode(name, characterSet));
        if (value != null) {
            this._buffer.append('=').append(this.encode(value, characterSet));
        }
        this._haveParameters = true;
    }

    @Override
    public void addFile(String parameterName, UploadFileSpec fileSpec) {
        throw new RuntimeException("May not URL-encode a file upload request");
    }

    private String encode(String source, String characterSet) {
        try {
            return URLEncoder.encode(source, characterSet);
        }
        catch (UnsupportedEncodingException e) {
            return "???";
        }
    }
}

