/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.scripting;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.scripting.ScriptingEngine;
import com.meterware.httpunit.scripting.ScriptingHandler;

public abstract class ScriptableDelegate
implements ScriptingHandler {
    private ScriptingEngine _scriptEngine;
    public static final ScriptingEngine NULL_SCRIPT_ENGINE = new ScriptingEngine(){

        @Override
        public boolean supportsScriptLanguage(String language) {
            return false;
        }

        @Override
        public String runScript(String language, String script) {
            return "";
        }

        @Override
        public boolean doEventScript(String eventScript) {
            return true;
        }

        @Override
        public boolean doEvent(String eventScript) {
            return true;
        }

        @Override
        public boolean handleEvent(String eventName) {
            return true;
        }

        @Override
        public Object evaluateExpression(String urlString) {
            return null;
        }

        @Override
        public ScriptingEngine newScriptingEngine(ScriptableDelegate child) {
            return this;
        }

        @Override
        public void clearCaches() {
        }
    };

    @Override
    public boolean supportsScriptLanguage(String language) {
        return this.getScriptEngine().supportsScriptLanguage(language);
    }

    @Override
    public boolean doEvent(String eventScript) {
        return this.doEventScript(eventScript);
    }

    @Override
    public boolean doEventScript(String eventScript) {
        return eventScript.length() == 0 || this.getScriptEngine().doEventScript(eventScript);
    }

    @Override
    public boolean handleEvent(String eventName) {
        String eventScript = (String)this.get(eventName);
        return this.doEventScript(eventScript);
    }

    @Override
    public String runScript(String language, String script) {
        return script.length() == 0 ? "" : this.getScriptEngine().runScript(language, script);
    }

    @Override
    public Object evaluateExpression(String urlString) {
        if (urlString.length() == 0) {
            return null;
        }
        return this.getScriptEngine().evaluateExpression(urlString);
    }

    @Override
    public void clearCaches() {
        this.getScriptEngine().clearCaches();
    }

    public Object get(String propertyName) {
        return null;
    }

    public Object get(int index) {
        return null;
    }

    public void set(String propertyName, Object value) {
        throw new RuntimeException("No such property: " + propertyName);
    }

    public void setScriptEngine(ScriptingEngine scriptEngine) {
        this._scriptEngine = scriptEngine;
    }

    public ScriptingEngine getScriptEngine() {
        return this._scriptEngine != null ? this._scriptEngine : NULL_SCRIPT_ENGINE;
    }

    public ScriptingEngine getScriptEngine(ScriptableDelegate child) {
        return this.getScriptEngine().newScriptingEngine(child);
    }

    protected ScriptableDelegate[] getDelegates(HTMLElement[] elements) {
        ScriptableDelegate[] result = new ScriptableDelegate[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = (ScriptableDelegate)elements[i].getScriptingHandler();
        }
        return result;
    }
}

