/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.pseudoserver.PseudoServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;

class ServerSocketFactory {
    private static ArrayList _sockets = new ArrayList();
    private static int _outstandingSockets;
    private static Object _releaseSemaphore;

    ServerSocketFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized ServerSocket newServerSocket() throws IOException {
        if (_sockets.isEmpty() && _outstandingSockets > PseudoServer.getWaitThreshhold()) {
            try {
                Object object = _releaseSemaphore;
                synchronized (object) {
                    _releaseSemaphore.wait(PseudoServer.getSocketReleaseWaitTime());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ++_outstandingSockets;
        if (!_sockets.isEmpty()) {
            return (ServerSocket)_sockets.remove(0);
        }
        ServerSocket serverSocket = new ServerSocket(0);
        serverSocket.setSoTimeout(1000);
        return serverSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void release(ServerSocket serverSocket) throws IOException {
        if (_sockets.size() >= 2 * PseudoServer.getWaitThreshhold()) {
            serverSocket.close();
        } else {
            _sockets.add(serverSocket);
            --_outstandingSockets;
            Object object = _releaseSemaphore;
            synchronized (object) {
                _releaseSemaphore.notify();
            }
        }
    }

    static {
        _releaseSemaphore = new Object();
    }
}

