/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.ServletUnitServletContext;
import com.meterware.servletunit.WebApplication;
import jakarta.servlet.ServletContext;

public abstract class ServletContextFactory {
    public static final ServletContextFactory DEFAULT_INSTANCE;
    private static ServletContextFactory singleton;

    public static final synchronized void setInstance(ServletContextFactory newInstance) {
        if (newInstance == null) {
            throw new NullPointerException();
        }
        singleton = newInstance;
    }

    public static final synchronized ServletContextFactory getInstance() {
        return singleton;
    }

    public static ServletContext create(WebApplication application) {
        return ServletContextFactory.getInstance().createInternal(application);
    }

    public abstract ServletContext createInternal(WebApplication var1);

    static {
        singleton = DEFAULT_INSTANCE = new DefaultServletContextFactory();
    }

    private static final class DefaultServletContextFactory
    extends ServletContextFactory {
        private DefaultServletContextFactory() {
        }

        @Override
        public ServletContext createInternal(WebApplication application) {
            return new ServletUnitServletContext(application);
        }
    }
}

