/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.SessionListenerDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class ServletUnitHttpSession
implements HttpSession {
    public static final String SESSION_COOKIE_NAME = "JSESSION";
    private ServletContext _servletContext;
    private SessionListenerDispatcher _listenerDispatcher;
    private static int _NextID = 1;
    private final long _creationTime = new Date().getTime();
    private final String _id = Integer.toString(_NextID++);
    private int _maxInactiveInterval;
    private long _lastAccessedTime = new Date().getTime();
    private boolean _invalid;
    private Hashtable _values = new Hashtable();
    private boolean _isNew = true;
    private String _userName;
    private String[] _roles;
    private URL _originalURL;

    ServletUnitHttpSession(ServletContext servletContext, SessionListenerDispatcher listenerDispatcher) {
        this._servletContext = servletContext;
        this._listenerDispatcher = listenerDispatcher;
    }

    public int getMaxInactiveInterval() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        this._maxInactiveInterval = interval;
    }

    public String getId() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._id;
    }

    public long getCreationTime() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._creationTime;
    }

    public long getLastAccessedTime() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._lastAccessedTime;
    }

    public boolean isNew() {
        return this._isNew;
    }

    public void invalidate() {
        this._listenerDispatcher.sendSessionDestroyed(this);
        this._invalid = true;
        this._values.clear();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public String[] getValueNames() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._values.keySet().toArray(new String[this._values.size()]);
    }

    public Object getAttribute(String name) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._values.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        if (value == null) {
            this.removeAttribute(name);
        } else if (!this._values.containsKey(name)) {
            this._values.put(name, value);
            this._listenerDispatcher.sendAttributeAdded(this, name, value);
        } else {
            Object oldValue = this._values.get(name);
            this._values.put(name, value);
            this._listenerDispatcher.sendAttributeReplaced(this, name, oldValue);
        }
    }

    public void removeAttribute(String name) {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        if (this._values.containsKey(name)) {
            Object oldValue = this._values.get(name);
            this._values.remove(name);
            this._listenerDispatcher.sendAttributeRemoved(this, name, oldValue);
        }
    }

    public Enumeration getAttributeNames() {
        if (this._invalid) {
            throw new IllegalStateException();
        }
        return this._values.keys();
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    void access() {
        this._lastAccessedTime = new Date().getTime();
        this._isNew = false;
    }

    URL getOriginalURL() {
        return this._originalURL;
    }

    void setOriginalURL(URL originalURL) {
        this._originalURL = originalURL;
    }

    void setUserInformation(String userName, String[] roles) {
        this._userName = userName;
        this._roles = roles;
    }

    String getUserName() {
        return this._userName;
    }

    String[] getRoles() {
        return this._roles;
    }

    boolean isInvalid() {
        return this._invalid;
    }
}

