/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.basic.db.schema.properties;

import com.top_logic.basic.Logger;
import com.top_logic.basic.StringServices;
import com.top_logic.basic.col.MapUtil;
import com.top_logic.basic.db.schema.properties.DBPropertiesSchema;
import com.top_logic.basic.sql.ConnectionPool;
import com.top_logic.basic.sql.DBHelper;
import com.top_logic.basic.sql.DBType;
import com.top_logic.basic.sql.H2Helper;
import com.top_logic.basic.sql.PooledConnection;
import com.top_logic.basic.util.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DBProperties
implements DBPropertiesSchema {
    public static final String GLOBAL_PROPERTY = "__global__";
    private ConnectionPool _pool;

    public DBProperties(ConnectionPool pool) {
        this._pool = pool;
    }

    public String getProperty(String aKey) {
        return this.getProperty(GLOBAL_PROPERTY, aKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProperty(String nodeName, String property) throws IllegalArgumentException {
        try {
            DBHelper sqlDialect = this.connectionPool().getSQLDialect();
            int theCounter = sqlDialect.retryCount();
            while (true) {
                PooledConnection connection = this.connectionPool().borrowReadConnection();
                try {
                    String string = DBProperties.getProperty(connection, nodeName, property);
                    return string;
                }
                catch (SQLException ex) {
                    if (!sqlDialect.canRetry(ex)) throw ex;
                    connection.closeConnection((Throwable)ex);
                    if (theCounter-- > 0) continue;
                    throw ex;
                }
                finally {
                    this.connectionPool().releaseReadConnection(connection);
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to get property '" + property + "' (node is: '" + nodeName + "')!", ex);
        }
    }

    public static String getProperty(PooledConnection connection, String nodeName, String property) throws IllegalArgumentException, SQLException {
        DBHelper sqlDialect = connection.getSQLDialect();
        if (StringServices.isEmpty((CharSequence)nodeName)) {
            throw new IllegalArgumentException("Given node is null or empty!");
        }
        if (StringServices.isEmpty((CharSequence)property)) {
            throw new IllegalArgumentException("Given key is null or empty!");
        }
        try (PreparedStatement theStatement = connection.prepareStatement("SELECT " + DBProperties.valueColumn(sqlDialect) + " FROM " + DBProperties.tableRef(sqlDialect) + " WHERE " + DBProperties.nodeColumn(sqlDialect) + "=? AND " + DBProperties.keyColumn(sqlDialect) + "=?");){
            String string;
            block18: {
                ResultSet theResultSet;
                block16: {
                    String string2;
                    block17: {
                        theStatement.setString(1, nodeName);
                        theStatement.setString(2, property);
                        theResultSet = theStatement.executeQuery();
                        try {
                            if (!theResultSet.next()) break block16;
                            string2 = theResultSet.getString(1);
                            if (theResultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (theResultSet != null) {
                                try {
                                    theResultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        theResultSet.close();
                    }
                    return string2;
                }
                string = null;
                if (theResultSet == null) break block18;
                theResultSet.close();
            }
            return string;
        }
    }

    public boolean setProperty(String property, String newValue) throws IllegalArgumentException {
        return this.setProperty(GLOBAL_PROPERTY, property, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProperty(String nodeName, String property, String newValue) throws IllegalArgumentException {
        boolean bl;
        PooledConnection connection = this.connectionPool().borrowWriteConnection();
        try {
            boolean result = DBProperties.setProperty(connection, nodeName, property, newValue);
            if (result) {
                connection.commit();
            }
            bl = result;
        }
        catch (Throwable throwable) {
            try {
                this.connectionPool().releaseWriteConnection(connection);
                throw throwable;
            }
            catch (SQLException ex) {
                throw new RuntimeException("Failed to set property '" + property + "' (node is: '" + nodeName + "')!", ex);
            }
        }
        this.connectionPool().releaseWriteConnection(connection);
        return bl;
    }

    public static boolean setProperty(PooledConnection connection, String nodeName, String property, String newValue) throws IllegalArgumentException, SQLException {
        DBProperties.logDebugUpdateStart(connection, nodeName, property, newValue);
        DBHelper sqlDialect = connection.getSQLDialect();
        if (StringServices.isEmpty((CharSequence)nodeName)) {
            throw new IllegalArgumentException("Given node is null or empty!");
        }
        if (StringServices.isEmpty((CharSequence)property)) {
            throw new IllegalArgumentException("Given key is null or empty!");
        }
        if (StringServices.isEmpty((CharSequence)newValue)) {
            DBProperties.deleteProperty(connection, nodeName, property);
        } else {
            String currentValue = DBProperties.getProperty(connection, nodeName, property);
            if (StringServices.equals((Object)currentValue, (Object)newValue)) {
                DBProperties.logDebugUpdateNotNecessary();
                return false;
            }
            boolean hasValue = currentValue != null;
            try (PreparedStatement theStatement = connection.prepareStatement(hasValue ? "UPDATE " + DBProperties.tableRef(sqlDialect) + " SET " + DBProperties.valueColumn(sqlDialect) + "=? WHERE " + DBProperties.nodeColumn(sqlDialect) + "=? AND " + DBProperties.keyColumn(sqlDialect) + "=?" : "INSERT INTO " + DBProperties.tableRef(sqlDialect) + " (" + DBProperties.valueColumn(sqlDialect) + "," + DBProperties.nodeColumn(sqlDialect) + "," + DBProperties.keyColumn(sqlDialect) + ") VALUES (?,?,?)");){
                theStatement.setString(1, newValue);
                theStatement.setString(2, nodeName);
                theStatement.setString(3, property);
                theStatement.executeUpdate();
            }
        }
        DBProperties.logDebugUpdateDone();
        return true;
    }

    private static void logDebugUpdateStart(PooledConnection connection, String nodeName, String property, String newValue) {
        if (DBProperties.isLoggingDebug()) {
            String connectionName = connection.getPool().getName();
            DBProperties.logDebug("Setting property '" + property + "' to '" + newValue + "' on node '" + nodeName + "' at connection '" + connectionName + "'.");
        }
    }

    private static void logDebugUpdateNotNecessary() {
        if (DBProperties.isLoggingDebug()) {
            DBProperties.logDebug("The property has already the new value.");
        }
    }

    private static void logDebugUpdateDone() {
        if (DBProperties.isLoggingDebug()) {
            DBProperties.logDebug("The property was updated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists() throws SQLException {
        ConnectionPool pool = this.connectionPool();
        PooledConnection connection = pool.borrowReadConnection();
        try {
            boolean bl = DBProperties.tableExists(connection);
            return bl;
        }
        finally {
            pool.releaseReadConnection(connection);
        }
    }

    public static boolean tableExists(PooledConnection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeQuery("SELECT * FROM " + DBProperties.tableRef(connection.getSQLDialect()) + " WHERE 1=0").close();
            boolean bl = true;
            return bl;
        }
    }

    public static Map<String, String> getPropertiesForNode(PooledConnection connection, String nodeName) throws SQLException {
        DBHelper sqlDialect = connection.getSQLDialect();
        StringBuilder stmt = new StringBuilder();
        stmt.append("SELECT ");
        stmt.append(DBProperties.keyColumn(sqlDialect));
        stmt.append(',');
        stmt.append(DBProperties.valueColumn(sqlDialect));
        stmt.append(" FROM ");
        stmt.append(DBProperties.tableRef(sqlDialect));
        stmt.append(" WHERE ");
        stmt.append(DBProperties.nodeColumn(sqlDialect));
        stmt.append("=?");
        try (PreparedStatement statement = connection.prepareStatement(stmt.toString());){
            HashMap<String, String> hashMap;
            block13: {
                statement.setString(1, nodeName);
                ResultSet result = statement.executeQuery();
                try {
                    HashMap<String, String> propertiesMap = new HashMap<String, String>();
                    while (result.next()) {
                        propertiesMap.put(result.getString(1), result.getString(2));
                    }
                    hashMap = propertiesMap;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return hashMap;
        }
    }

    public static Map<String, String> getProperties(PooledConnection connection, String nodeName, String ... properties) throws SQLException {
        switch (properties.length) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                String property = properties[0];
                return Collections.singletonMap(property, DBProperties.getProperty(connection, nodeName, property));
            }
        }
        DBHelper sqlDialect = connection.getSQLDialect();
        StringBuilder stmt = new StringBuilder();
        stmt.append("SELECT ");
        stmt.append(DBProperties.keyColumn(sqlDialect));
        stmt.append(',');
        stmt.append(DBProperties.valueColumn(sqlDialect));
        stmt.append(" FROM ");
        stmt.append(DBProperties.tableRef(sqlDialect));
        stmt.append(" WHERE ");
        stmt.append(DBProperties.nodeColumn(sqlDialect));
        stmt.append("=? AND ");
        stmt.append(DBProperties.keyColumn(sqlDialect));
        stmt.append(" IN  (");
        sqlDialect.literal((Appendable)stmt, DBType.STRING, (Object)properties[0]);
        for (int i = 1; i < properties.length; ++i) {
            stmt.append(", ");
            sqlDialect.literal((Appendable)stmt, DBType.STRING, (Object)properties[i]);
        }
        stmt.append(")");
        try (PreparedStatement statement = connection.prepareStatement(stmt.toString());){
            HashMap throwable2;
            block20: {
                statement.setString(1, nodeName);
                ResultSet result = statement.executeQuery();
                try {
                    HashMap propertiesMap = MapUtil.newMap((int)properties.length);
                    while (result.next()) {
                        propertiesMap.put(result.getString(1), result.getString(2));
                    }
                    if (properties.length > propertiesMap.size()) {
                        for (String property : properties) {
                            if (propertiesMap.containsKey(property)) continue;
                            propertiesMap.put(property, null);
                        }
                    }
                    throwable2 = propertiesMap;
                    if (result == null) break block20;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return throwable2;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean compareAndSet(PooledConnection connection, String nodeName, String property, String expect, String update) throws SQLException {
        if (Utils.equals((Object)update, (Object)expect)) {
            return Utils.equals((Object)expect, (Object)DBProperties.getProperty(connection, nodeName, property));
        }
        DBHelper sqlDialect = connection.getSQLDialect();
        int retryCount = sqlDialect.retryCount();
        StringBuilder selectStmtString = DBProperties.newSelectStmt(sqlDialect);
        while (true) {
            try (PreparedStatement updateRowStmt = connection.prepareStatement(selectStmtString.toString(), 1003, 1008);){
                boolean bl;
                block22: {
                    ResultSet result;
                    block20: {
                        boolean bl2;
                        block21: {
                            updateRowStmt.setString(1, nodeName);
                            updateRowStmt.setString(2, property);
                            result = updateRowStmt.executeQuery();
                            try {
                                if (!result.next()) break block20;
                                boolean updated = DBProperties.update(result, expect, update);
                                assert (!result.next()) : "More than one row with the same key values.";
                                bl2 = updated;
                                if (result == null) break block21;
                            }
                            catch (Throwable throwable) {
                                if (result != null) {
                                    try {
                                        result.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            result.close();
                        }
                        return bl2;
                    }
                    DBProperties.insert(result, nodeName, property, update);
                    bl = true;
                    if (result == null) break block22;
                    result.close();
                }
                return bl;
            }
            catch (SQLException ex) {
                if (retryCount-- > 0) {
                    DBProperties.logRetryUpdate(nodeName, property, retryCount, ex);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private static StringBuilder newSelectStmt(DBHelper sqlDialect) {
        boolean isH2 = sqlDialect instanceof H2Helper;
        StringBuilder lockStmtString = new StringBuilder();
        lockStmtString.append("SELECT ");
        lockStmtString.append(DBProperties.nodeColumn(sqlDialect));
        if (!isH2) {
            lockStmtString.append(" AS ");
            lockStmtString.append("node");
        }
        lockStmtString.append(',');
        lockStmtString.append(DBProperties.keyColumn(sqlDialect));
        if (!isH2) {
            lockStmtString.append(" AS ");
            lockStmtString.append("propKey");
        }
        lockStmtString.append(',');
        lockStmtString.append(DBProperties.valueColumn(sqlDialect));
        if (!isH2) {
            lockStmtString.append(" AS ");
            lockStmtString.append("propValue");
        }
        lockStmtString.append(" FROM ");
        lockStmtString.append(DBProperties.tableRef(sqlDialect));
        lockStmtString.append(sqlDialect.forUpdate1());
        lockStmtString.append(" WHERE ");
        lockStmtString.append(DBProperties.nodeColumn(sqlDialect));
        lockStmtString.append("=? ");
        lockStmtString.append("AND ");
        lockStmtString.append(DBProperties.keyColumn(sqlDialect));
        lockStmtString.append("=?");
        lockStmtString.append(sqlDialect.forUpdate2());
        return lockStmtString;
    }

    private static void logRetryUpdate(String nodeName, String property, int retryCount, SQLException ex) {
        Logger.info((String)("Retry " + retryCount + " times to get value for node '" + nodeName + "' and property '" + property + "' '" + ex.getMessage() + "'"), DBProperties.class);
    }

    private static void insert(ResultSet result, String node, String property, String value) throws SQLException {
        result.moveToInsertRow();
        result.updateString("node", node);
        result.updateString("propKey", property);
        result.updateString("propValue", value);
        result.insertRow();
    }

    private static boolean update(ResultSet resultSet, String expect, String update) throws SQLException {
        String currentValue = resultSet.getString("propValue");
        if (!StringServices.equals((Object)currentValue, (Object)expect)) {
            return false;
        }
        if (StringServices.isEmpty((CharSequence)update)) {
            resultSet.deleteRow();
        } else {
            resultSet.updateString("propValue", update);
            resultSet.updateRow();
        }
        return true;
    }

    private static void deleteProperty(PooledConnection connection, String aNode, String aKey) throws SQLException {
        DBHelper sqlDialect = connection.getSQLDialect();
        try (PreparedStatement theStatement = connection.prepareStatement("DELETE FROM " + DBProperties.tableRef(sqlDialect) + " WHERE " + DBProperties.nodeColumn(sqlDialect) + "=? AND " + DBProperties.keyColumn(sqlDialect) + "=?");){
            theStatement.setString(1, aNode);
            theStatement.setString(2, aKey);
            theStatement.executeUpdate();
        }
    }

    private static String tableRef(DBHelper sqlDialect) {
        return sqlDialect.tableRef("TL_PROPERTIES");
    }

    private static String keyColumn(DBHelper sqlDialect) {
        return sqlDialect.columnRef("propKey");
    }

    private static String nodeColumn(DBHelper sqlDialect) {
        return sqlDialect.columnRef("node");
    }

    private static String valueColumn(DBHelper sqlDialect) {
        return sqlDialect.columnRef("propValue");
    }

    public ConnectionPool connectionPool() {
        return this._pool;
    }

    private static boolean isLoggingDebug() {
        return Logger.isDebugEnabled(DBProperties.class);
    }

    private static void logDebug(String message) {
        Logger.debug((String)message, DBProperties.class);
    }
}

