/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.basic.db.schema.setup;

import com.top_logic.basic.ConfigurationError;
import com.top_logic.basic.Log;
import com.top_logic.basic.UnreachableAssertion;
import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.ConfiguredInstance;
import com.top_logic.basic.config.DefaultInstantiationContext;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.NamedInstanceConfig;
import com.top_logic.basic.config.NamedResource;
import com.top_logic.basic.config.PolymorphicConfiguration;
import com.top_logic.basic.config.ResourceDeclaration;
import com.top_logic.basic.config.SimpleInstantiationContext;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.basic.db.model.DBColumn;
import com.top_logic.basic.db.model.DBColumnRef;
import com.top_logic.basic.db.model.DBIndex;
import com.top_logic.basic.db.model.DBPrimary;
import com.top_logic.basic.db.model.DBSchema;
import com.top_logic.basic.db.model.DBSchemaFactory;
import com.top_logic.basic.db.model.DBSchemaPart;
import com.top_logic.basic.db.model.DBTable;
import com.top_logic.basic.db.model.util.DBSchemaUtils;
import com.top_logic.basic.db.schema.io.MORepositoryBuilder;
import com.top_logic.basic.db.schema.setup.config.SchemaConfiguration;
import com.top_logic.basic.db.schema.setup.config.TypeProvider;
import com.top_logic.basic.sql.ConnectionPool;
import com.top_logic.basic.sql.DBHelper;
import com.top_logic.basic.sql.DBType;
import com.top_logic.basic.sql.PooledConnection;
import com.top_logic.dob.MOAttribute;
import com.top_logic.dob.MOFactory;
import com.top_logic.dob.MetaObject;
import com.top_logic.dob.attr.MOAttributeImpl;
import com.top_logic.dob.attr.MOPrimitive;
import com.top_logic.dob.ex.DuplicateAttributeException;
import com.top_logic.dob.ex.IncompatibleTypeException;
import com.top_logic.dob.ex.UnknownTypeException;
import com.top_logic.dob.meta.DefaultMORepository;
import com.top_logic.dob.meta.MOClass;
import com.top_logic.dob.meta.MOClassImpl;
import com.top_logic.dob.meta.MOIndex;
import com.top_logic.dob.meta.MOIndexImpl;
import com.top_logic.dob.meta.MORepository;
import com.top_logic.dob.meta.MOStructure;
import com.top_logic.dob.schema.config.MetaObjectName;
import com.top_logic.dob.schema.config.MetaObjectsConfig;
import com.top_logic.dob.schema.config.annotation.DirectIndexColumnsStrategy;
import com.top_logic.dob.schema.config.annotation.IndexColumnsStrategy;
import com.top_logic.dob.schema.config.annotation.IndexColumnsStrategyAnnotation;
import com.top_logic.dob.sql.DBAttribute;
import com.top_logic.dob.sql.DBTableMetaObject;
import com.top_logic.dsa.util.ConfigResourceLoader;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchemaSetup
implements ConfiguredInstance<SchemaConfiguration> {
    private final SchemaConfiguration _schemaConfig;

    public SchemaSetup(InstantiationContext context, SchemaConfiguration config) {
        this._schemaConfig = config;
    }

    public SchemaConfiguration getConfig() {
        return this._schemaConfig;
    }

    public final SchemaSetup resolve(InstantiationContext context) throws ConfigurationException {
        if (this.isResolved()) {
            return this;
        }
        return this.internalResolve(context);
    }

    protected SchemaSetup internalResolve(InstantiationContext context) throws ConfigurationException {
        SchemaConfiguration copy = (SchemaConfiguration)TypedConfiguration.copy((ConfigurationItem)this.getConfig());
        SchemaSetup.resolveDeclarations(context, copy);
        this.addAdditionalTables(copy);
        return (SchemaSetup)context.getInstance((PolymorphicConfiguration)copy);
    }

    private void addAdditionalTables(SchemaConfiguration copy) {
        DBSchema schema = this.buildSchema();
        copy.setAdditionalTables(schema);
    }

    public static void resolveDeclarations(InstantiationContext context, SchemaConfiguration schema) throws ConfigurationException {
        MetaObjectsConfig typeSystem = MORepositoryBuilder.readTypeSystem(context, schema.getDeclarations());
        if (schema.getMetaObjects() == null) {
            schema.setMetaObjects(typeSystem);
        } else {
            ArrayList resolvedTypes = new ArrayList(typeSystem.getTypes().values());
            typeSystem.getTypes().clear();
            for (MetaObjectName type : resolvedTypes) {
                schema.getMetaObjects().getTypes().put(type.getObjectName(), type);
            }
        }
        schema.getDeclarations().clear();
    }

    private boolean isResolved() {
        return this.getConfig().getDeclarations().isEmpty();
    }

    public final void createTypes(InstantiationContext context, MORepository repository, MOFactory typeFactory) {
        this.internalCreateTypes(context, repository, typeFactory);
    }

    protected void internalCreateTypes(InstantiationContext context, MORepository repository, MOFactory typeFactory) {
        MetaObjectsConfig metaObjects = this.getConfig().getMetaObjects();
        if (metaObjects == null) {
            throw new IllegalStateException("SchemaSetup not resolved.");
        }
        new MORepositoryBuilder((Log)context, typeFactory, repository).build(metaObjects);
        List<NamedInstanceConfig<? extends TypeProvider>> providerConfigs = this.getConfig().getProviders();
        List providers = TypedConfiguration.getInstanceListNamed((InstantiationContext)context, providerConfigs);
        for (TypeProvider provider : providers) {
            provider.createTypes((Log)context, typeFactory, repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables(ConnectionPool pool, MORepository typeRepository, boolean checkExistence) throws SQLException {
        DBSchema schema = this.buildSchema(typeRepository);
        PooledConnection connection = pool.borrowWriteConnection();
        try {
            DBSchemaUtils.createTables((PooledConnection)connection, (DBSchema)schema, (boolean)checkExistence);
        }
        finally {
            pool.releaseWriteConnection(connection);
        }
    }

    public void printCreateTables(Appendable out, MORepository typeRepository, DBHelper sqlDialect) {
        DBSchema schema = this.buildSchema(typeRepository);
        DBSchemaUtils.toSQL((Appendable)out, (DBHelper)sqlDialect, (DBSchemaPart)schema);
    }

    public void resetTables(ConnectionPool pool, MORepository typeRepository, boolean truncate) {
        DBSchema schema = this.buildSchema(typeRepository);
        DBSchemaUtils.resetTables((ConnectionPool)pool, (DBSchema)schema, (boolean)truncate);
    }

    public void printResetTables(PrintWriter out, MORepository typeRepository, DBHelper sqlDialect, boolean truncate) {
        DBSchema schema = this.buildSchema(typeRepository);
        for (DBTable table : schema.getTables()) {
            String tableName = table.getDBName();
            if (truncate) {
                out.println(sqlDialect.getTruncateTableStatement(tableName));
            } else {
                out.println("DROP TABLE " + sqlDialect.tableRef(tableName));
            }
            out.println(';');
            out.println();
        }
    }

    public final DBSchema buildSchema(MORepository typeRepository) {
        DBSchema schema = this.buildSchema();
        SchemaSetup.addTables(schema, typeRepository);
        return schema;
    }

    public DBSchema buildSchema() {
        List<NamedResource> schemas = this.getConfig().getSchemas();
        DBSchema schema = SchemaSetup.newDBSchema(schemas);
        schema.setName(null);
        return schema;
    }

    public static void addTables(DBSchema schema, MORepository typeRepository) {
        List moNames = typeRepository.getMetaObjectNames();
        try {
            SchemaSetup.addTables(schema, typeRepository, moNames);
        }
        catch (UnknownTypeException e) {
            throw new UnreachableAssertion("Iterated over all types in the repository.");
        }
    }

    public static void addTables(DBSchema schema, MORepository typeRepository, Collection<String> moNames) throws UnknownTypeException {
        for (String name : moNames) {
            MOClass type;
            MetaObject metaObject = typeRepository.getMetaObject(name);
            if (metaObject.getKind() != MetaObject.Kind.item || (type = (MOClass)metaObject).isAbstract()) continue;
            schema.getTables().add(SchemaSetup.createTable(type));
        }
    }

    public static DBTable createTable(MOClass type) {
        DBTable result = SchemaSetup.createDBTable(type);
        IndexColumnsStrategy indexStrategy = SchemaSetup.getIndexStrategy(type);
        List indexes = type.getIndexes();
        int n = indexes.size();
        for (int i = 0; i < n; ++i) {
            SchemaSetup.addIndex(type, result, (com.top_logic.dob.sql.DBIndex)indexes.get(i), indexStrategy);
        }
        return result;
    }

    private static DBTable createDBTable(MOClass type) {
        DBTable result = DBSchemaFactory.createTable((String)type.getName());
        DBTableMetaObject dbMapping = type.getDBMapping();
        result.setExplicitDBName(dbMapping.getDBName());
        List attrs = dbMapping.getDBAttributes();
        int cnt = attrs.size();
        for (int n = 0; n < cnt; ++n) {
            DBAttribute attr = (DBAttribute)attrs.get(n);
            DBType dbType = attr.getSQLType();
            int dbSize = attr.getSQLSize();
            int dbPrec = attr.getSQLPrecision();
            boolean dbMandatory = attr.isSQLNotNull();
            boolean binary = attr.isBinary();
            DBColumn column = DBSchemaFactory.createColumn((String)attr.getDBName());
            column.setType(dbType);
            column.setBinary(binary);
            column.setMandatory(dbMandatory);
            column.setSize((long)dbSize);
            column.setPrecision(dbPrec);
            result.getColumns().add(column);
        }
        MOIndex primaryKey = type.getPrimaryKey();
        if (primaryKey != null) {
            DBPrimary primary = DBSchemaFactory.createPrimary();
            for (DBAttribute keyColumn : primaryKey.getKeyAttributes()) {
                primary.getColumnRefs().add(DBSchemaFactory.ref((String)keyColumn.getDBName()));
            }
            result.setPrimaryKey(primary);
        }
        result.setPKeyStorage(dbMapping.isPKeyStorage());
        result.setCompress(dbMapping.getCompress());
        return result;
    }

    private static void addIndex(MOClass type, DBTable table, com.top_logic.dob.sql.DBIndex index, IndexColumnsStrategy indexStrategy) {
        if (index.isInMemory()) {
            return;
        }
        DBIndex dbIndex = DBSchemaFactory.createIndex((String)index.getDBName());
        if (index.isUnique()) {
            dbIndex.setKind(DBIndex.Kind.UNIQUE);
        } else {
            dbIndex.setKind(DBIndex.Kind.DEFAULT);
        }
        dbIndex.setCompress(index.getCompress());
        List indexColumns = indexStrategy.createIndexColumns(type, index);
        int size = indexColumns.size();
        for (int n = 0; n < size; ++n) {
            dbIndex.getColumnRefs().add(DBSchemaFactory.ref((String)((DBAttribute)indexColumns.get(n)).getDBName()));
        }
        table.getIndices().add(dbIndex);
    }

    public MORepository createMORepository(MOFactory typeFactory) {
        InstantiationContext context = SimpleInstantiationContext.CREATE_ALWAYS_FAIL_IMMEDIATELY;
        DefaultMORepository repository = new DefaultMORepository(this.getConfig().hasMultipleBranches());
        this.createTypes(context, (MORepository)repository, typeFactory);
        repository.resolveReferences();
        return repository;
    }

    public static MOClass createTableType(DBTable table, MOFactory factory) {
        MOClassImpl tableType = (MOClassImpl)factory.createMOClass(table.getName());
        tableType.setDBName(table.getDBName());
        for (DBColumn column : table.getColumns()) {
            String columnName = column.getName();
            DBType dbType = column.getType();
            MetaObject targetType = SchemaSetup.toPrimitive(dbType);
            int dbSize = (int)column.getSize();
            int dbPrecision = column.getPrecision();
            boolean mandatory = column.isMandatory();
            MOAttribute attribute = factory.createMOAttribute(columnName, targetType);
            attribute.setMandatory(mandatory);
            attribute.setImmutable(false);
            ((MOAttributeImpl)attribute).setDBName(column.getDBName());
            ((MOAttributeImpl)attribute).setSQLType(dbType);
            ((MOAttributeImpl)attribute).setSQLSize(dbSize);
            ((MOAttributeImpl)attribute).setSQLPrecision(dbPrecision);
            try {
                tableType.addAttribute(attribute);
            }
            catch (DuplicateAttributeException ex) {
                throw new UnreachableAssertion("Table with non-unique column names.", (Throwable)ex);
            }
        }
        for (DBIndex index : table.getIndices()) {
            MOIndexImpl moIndex;
            switch (index.getKind()) {
                case DEFAULT: {
                    moIndex = SchemaSetup.newIndex((MOStructure)tableType, index, false);
                    break;
                }
                case UNIQUE: {
                    moIndex = SchemaSetup.newIndex((MOStructure)tableType, index, true);
                    break;
                }
                case PRIMARY: {
                    moIndex = MOIndexImpl.newPrimaryKey((DBAttribute[])SchemaSetup.getIndexAttribute((MOStructure)tableType, index.getColumnRefs()));
                    break;
                }
                default: {
                    throw new UnreachableAssertion("No such kind " + index.getKind());
                }
            }
            tableType.addIndex((MOIndex)moIndex);
        }
        return tableType;
    }

    static MOIndexImpl newIndex(MOStructure tableType, DBIndex index, boolean uniqueFlag) {
        DBAttribute[] columns = SchemaSetup.getIndexAttribute(tableType, index.getColumnRefs());
        try {
            return new MOIndexImpl(index.getName(), index.getDBName(), columns, uniqueFlag, false, false, index.getCompress());
        }
        catch (IncompatibleTypeException ex) {
            throw new ConfigurationError("Invalid index definition: " + index, (Throwable)ex);
        }
    }

    private static DBAttribute[] getIndexAttribute(MOStructure tableType, List<DBColumnRef> columnRefs) {
        DBAttribute[] indexAttributes = new DBAttribute[columnRefs.size()];
        for (int i = 0; i < indexAttributes.length; ++i) {
            indexAttributes[i] = (MOAttributeImpl)tableType.getAttribute(columnRefs.get(i).getName());
        }
        return indexAttributes;
    }

    static MetaObject toPrimitive(DBType type) {
        switch (type) {
            case BLOB: {
                return MOPrimitive.BLOB;
            }
            case BOOLEAN: {
                return MOPrimitive.BOOLEAN;
            }
            case BYTE: {
                return MOPrimitive.BYTE;
            }
            case CHAR: {
                return MOPrimitive.CHARACTER;
            }
            case CLOB: {
                return MOPrimitive.CLOB;
            }
            case DATE: {
                return MOPrimitive.DATE;
            }
            case DATETIME: {
                return MOPrimitive.DATE;
            }
            case DECIMAL: {
                return MOPrimitive.DOUBLE;
            }
            case DOUBLE: {
                return MOPrimitive.DOUBLE;
            }
            case FLOAT: {
                return MOPrimitive.FLOAT;
            }
            case ID: {
                return MOPrimitive.TLID;
            }
            case INT: {
                return MOPrimitive.INTEGER;
            }
            case LONG: {
                return MOPrimitive.LONG;
            }
            case SHORT: {
                return MOPrimitive.SHORT;
            }
            case STRING: {
                return MOPrimitive.STRING;
            }
            case TIME: {
                return MOPrimitive.DATE;
            }
        }
        throw new UnreachableAssertion("No such type: " + type);
    }

    private static IndexColumnsStrategy getIndexStrategy(MOClass self) {
        IndexColumnsStrategyAnnotation annotation = (IndexColumnsStrategyAnnotation)self.getAnnotation(IndexColumnsStrategyAnnotation.class);
        if (annotation == null) {
            MOClass superclass = self.getSuperclass();
            if (superclass != null) {
                return SchemaSetup.getIndexStrategy(superclass);
            }
            return DirectIndexColumnsStrategy.INSTANCE;
        }
        return annotation.getStrategy();
    }

    public static DBSchema newDBSchema(List<? extends ResourceDeclaration> schemas) {
        DBSchema schema;
        if (schemas.isEmpty()) {
            return DBSchemaUtils.newDBSchema();
        }
        try {
            DefaultInstantiationContext ctx = new DefaultInstantiationContext(DBSchemaUtils.class);
            schema = (DBSchema)ConfigResourceLoader.loadDeclarations((InstantiationContext)ctx, (String)"schema", DBSchema.class, schemas);
            ctx.checkErrors();
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationError("Loading schema declarations failed.", ex);
        }
        return schema;
    }
}

