/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.basic.db.schema.io;

import com.top_logic.basic.CollectionUtil;
import com.top_logic.basic.Log;
import com.top_logic.basic.col.TupleFactory;
import com.top_logic.basic.config.ConfigurationException;
import com.top_logic.basic.config.ConfigurationItem;
import com.top_logic.basic.config.Decision;
import com.top_logic.basic.config.DefaultInstantiationContext;
import com.top_logic.basic.config.InstantiationContext;
import com.top_logic.basic.config.PolymorphicConfiguration;
import com.top_logic.basic.config.ResourceDeclaration;
import com.top_logic.basic.config.TypedConfiguration;
import com.top_logic.basic.config.constraint.check.ConstraintChecker;
import com.top_logic.dob.MOAlternativeBuilder;
import com.top_logic.dob.MOAttribute;
import com.top_logic.dob.MOFactory;
import com.top_logic.dob.MetaObject;
import com.top_logic.dob.ex.DuplicateAttributeException;
import com.top_logic.dob.ex.DuplicateTypeException;
import com.top_logic.dob.meta.DeferredIndex;
import com.top_logic.dob.meta.DeferredMetaObject;
import com.top_logic.dob.meta.MOAnnotation;
import com.top_logic.dob.meta.MOClass;
import com.top_logic.dob.meta.MOClassImpl;
import com.top_logic.dob.meta.MOIndex;
import com.top_logic.dob.meta.MORepository;
import com.top_logic.dob.meta.MOStructureImpl;
import com.top_logic.dob.schema.config.AlternativeConfig;
import com.top_logic.dob.schema.config.AssociationConfig;
import com.top_logic.dob.schema.config.AttributeConfig;
import com.top_logic.dob.schema.config.IndexConfig;
import com.top_logic.dob.schema.config.IndexPartConfig;
import com.top_logic.dob.schema.config.MetaObjectConfig;
import com.top_logic.dob.schema.config.MetaObjectName;
import com.top_logic.dob.schema.config.MetaObjectsConfig;
import com.top_logic.dob.schema.config.PrimaryKeyConfig;
import com.top_logic.dsa.util.ConfigResourceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MORepositoryBuilder {
    public static final String ROOT_TAG = "objectlist";
    private final Log _log;
    private final MOFactory _typeFactory;
    private final MORepository _repository;
    private Map<String, MetaObject> _typesByName = new HashMap<String, MetaObject>();
    final InstantiationContext _context;

    public MORepositoryBuilder(Log log, MOFactory typeFactory, MORepository repository) {
        this._log = log;
        this._typeFactory = typeFactory;
        this._repository = repository;
        this._context = new DefaultInstantiationContext(this._log);
    }

    public void build(MetaObjectsConfig config) {
        this.createMetaObjects(config);
        this.addToRepository();
    }

    private void addToRepository() {
        for (MetaObject type : this._typesByName.values()) {
            try {
                this.repository().addMetaObject(type);
            }
            catch (DuplicateTypeException ex) {
                this.error("Duplicate type", ex);
            }
        }
    }

    private void createMetaObjects(MetaObjectsConfig config) {
        ArrayList<ClassResolver> resolvers = new ArrayList<ClassResolver>();
        for (MetaObjectName metaObjectName : config.getTypes().values()) {
            Resolver resolver = metaObjectName instanceof AssociationConfig ? this.addAssociationMetaObject((AssociationConfig)metaObjectName) : (metaObjectName instanceof AlternativeConfig ? this.createAlternative((AlternativeConfig)metaObjectName) : this.createClass((MetaObjectConfig)metaObjectName));
            this.addType(((Resolver)resolver).getType());
            resolvers.add((ClassResolver)resolver);
        }
        for (Resolver resolver : resolvers) {
            resolver.resolveSuperType();
        }
        for (Resolver resolver : resolvers) {
            resolver.resolveAttributes(this._log);
        }
        for (Resolver resolver : resolvers) {
            resolver.resolveIndices(this._log);
        }
    }

    private Resolver createAlternative(AlternativeConfig config) {
        MOAlternativeBuilder alternative = this.typeFactory().createAlternativeBuilder(config.getObjectName());
        return new AlternativeResolver(config, alternative);
    }

    private ClassResolver addAssociationMetaObject(AssociationConfig config) {
        MOClass type = this.createClassBase((MetaObjectConfig)config);
        type.setAssociation(true);
        return new AssociationResolver(config, type);
    }

    private ClassResolver createClass(MetaObjectConfig config) {
        MOClass type = this.createClassBase(config);
        return new ClassResolver(config, type);
    }

    private MOClass createClassBase(MetaObjectConfig config) {
        this.checkCorrectMOType(config);
        MOClassImpl type = (MOClassImpl)this.typeFactory().createMOClass(config.getObjectName());
        type.setAbstract(config.isAbstract());
        Decision versioned = config.isVersioned();
        if (versioned != Decision.DEFAULT) {
            type.setVersioned(versioned.toBoolean(true));
        }
        type.setDBName(config.getDBNameEffective());
        type.setPkeyStorage(config.isUsePKS());
        type.setCompress(config.getDBCompress());
        type.setDefiningResource(config.location().getResource());
        for (MOAnnotation annotation : config.getAnnotations()) {
            type.addAnnotation(annotation);
        }
        return type;
    }

    MetaObject lookupType(ConfigurationItem context, String name) {
        MetaObject result = this._typesByName.get(name);
        if (result == null) {
            result = new DeferredMetaObject(name);
        }
        return result;
    }

    void addType(MetaObject type) {
        this._typesByName.put(type.getName(), type);
    }

    private void checkCorrectMOType(MetaObjectConfig moConfig) {
        if (!CollectionUtil.equals((Object)moConfig.getObjectType(), (Object)"MOKnowledgeObject")) {
            this.error("Attribute 'object_type' in metaobject '" + moConfig.getObjectName() + "' is not supported.");
        }
    }

    void error(String message) {
        this._log.error(message);
    }

    void error(String message, Throwable ex) {
        this._log.error(message, ex);
    }

    private MOFactory typeFactory() {
        return this._typeFactory;
    }

    private MORepository repository() {
        return this._repository;
    }

    public static void buildRepository(InstantiationContext context, MOFactory typeFactory, List<ResourceDeclaration> typeDefinitions, MORepository repository) throws ConfigurationException {
        MetaObjectsConfig config = MORepositoryBuilder.readTypeSystem(context, typeDefinitions);
        new MORepositoryBuilder((Log)context, typeFactory, repository).build(config);
    }

    public static MetaObjectsConfig readTypeSystem(InstantiationContext context, List<ResourceDeclaration> typeDefinitions) throws ConfigurationException {
        if (typeDefinitions.isEmpty()) {
            return (MetaObjectsConfig)TypedConfiguration.newConfigItem(MetaObjectsConfig.class);
        }
        MetaObjectsConfig config = (MetaObjectsConfig)ConfigResourceLoader.loadDeclarations((InstantiationContext)context, (String)ROOT_TAG, MetaObjectsConfig.class, typeDefinitions);
        new ConstraintChecker().check((Log)context, (ConfigurationItem)config);
        context.checkErrors();
        return config;
    }

    private final class AlternativeResolver
    extends Resolver {
        private final AlternativeConfig _config;
        private final MOAlternativeBuilder _type;

        public AlternativeResolver(AlternativeConfig config, MOAlternativeBuilder alternative) {
            this._type = alternative;
            this._config = config;
        }

        @Override
        public MetaObject getType() {
            return this._type;
        }

        @Override
        public void resolveSuperType() {
            for (AlternativeConfig.TypeChoice specializationConfig : this._config.getSpecialisations()) {
                this._type.registerSpecialisation(MORepositoryBuilder.this.lookupType((ConfigurationItem)specializationConfig, specializationConfig.getName()));
            }
        }

        @Override
        public void resolveAttributes(Log log) {
        }

        @Override
        public void resolveIndices(Log log) {
        }
    }

    class ClassResolver
    extends Resolver {
        final MetaObjectConfig _config;
        final MOClass _type;

        public ClassResolver(MetaObjectConfig config, MOClass type) {
            this._config = config;
            this._type = type;
        }

        @Override
        public MetaObject getType() {
            return this._type;
        }

        @Override
        public void resolveSuperType() {
            String superClassName = this._config.getSuperClass();
            if (superClassName != null) {
                MetaObject superType = MORepositoryBuilder.this.lookupType((ConfigurationItem)this._config, superClassName);
                if (superType instanceof MOAlternativeBuilder) {
                    ((MOAlternativeBuilder)superType).registerSpecialisation((MetaObject)this._type);
                } else {
                    MOClass superClass = (MOClass)superType;
                    this._type.setSuperclass(superClass);
                }
            }
        }

        @Override
        public void resolveAttributes(Log log) {
            for (AttributeConfig attributeConfig : this._config.getAttributes()) {
                String name = attributeConfig.getAttributeName();
                boolean override = attributeConfig.isOverride();
                MOAttribute attribute = (MOAttribute)MORepositoryBuilder.this._context.getInstance((PolymorphicConfiguration)attributeConfig);
                try {
                    if (override) {
                        this._type.overrideAttribute(attribute);
                        continue;
                    }
                    this._type.addAttribute(attribute);
                }
                catch (DuplicateAttributeException ex) {
                    log.error("Duplicate Attribute '" + name + "' in type '" + this._type.getName() + "'.", (Throwable)ex);
                }
            }
        }

        @Override
        public void resolveIndices(Log log) {
            PrimaryKeyConfig primaryKey;
            List indexes = this._config.getIndex();
            if (!indexes.isEmpty()) {
                for (IndexConfig indexConfig : indexes) {
                    this.addIndex(log, indexConfig);
                }
            }
            if ((primaryKey = this._config.getPrimaryKey()) != null) {
                this.addPrimaryKey(log, primaryKey);
            }
        }

        private void addPrimaryKey(Log log, PrimaryKeyConfig config) {
            List partConfigs = config.getIndexParts();
            if (partConfigs.isEmpty()) {
                log.error("Primary key with no columns, ignored");
                return;
            }
            ArrayList<TupleFactory.Pair> attributeParts = new ArrayList<TupleFactory.Pair>(partConfigs.size());
            for (IndexPartConfig partConfig : partConfigs) {
                attributeParts.add(new TupleFactory.Pair((Object)partConfig.getName(), (Object)partConfig.getPart()));
            }
            ((MOStructureImpl)this._type).setPrimaryKey(DeferredIndex.newPrimaryKey(attributeParts));
        }

        private void addIndex(Log log, IndexConfig indexConfig) {
            String indexName = indexConfig.getName();
            List partConfigs = indexConfig.getIndexParts();
            if (partConfigs.isEmpty()) {
                log.error("Index " + indexName + " with no columns, ignored");
                return;
            }
            DeferredIndex index = new DeferredIndex(indexName, indexConfig.getDBNameEffective(), indexConfig.isUnique(), indexConfig.isCustom(), indexConfig.isInMemory(), indexConfig.getDBCompress());
            ArrayList<TupleFactory.Pair> attributeParts = new ArrayList<TupleFactory.Pair>(partConfigs.size());
            for (IndexPartConfig partConfig : partConfigs) {
                attributeParts.add(new TupleFactory.Pair((Object)partConfig.getName(), (Object)partConfig.getPart()));
            }
            index.setAttributeParts(attributeParts);
            ((MOClassImpl)this._type).addIndex((MOIndex)index);
        }
    }

    class AssociationResolver
    extends ClassResolver {
        public AssociationResolver(AssociationConfig config, MOClass type) {
            super((MetaObjectConfig)config, type);
        }
    }

    abstract class Resolver {
        Resolver() {
        }

        public abstract MetaObject getType();

        public abstract void resolveSuperType();

        public abstract void resolveAttributes(Log var1);

        public abstract void resolveIndices(Log var1);
    }
}

