/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.config.diff.filediff;

import com.top_logic.config.diff.filediff.LinePart;
import com.top_logic.config.diff.google.diff_match_patch;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractLine {
    private final List<LinePart> lineParts;

    protected AbstractLine() {
        this(new ArrayList<LinePart>());
    }

    protected AbstractLine(List<LinePart> lineParts) {
        this.lineParts = lineParts;
    }

    public boolean isUnchanged() {
        boolean isEqual = true;
        for (LinePart linePart : this.getLineParts()) {
            if (diff_match_patch.Operation.EQUAL.equals((Object)linePart.getOperation())) continue;
            isEqual = false;
            break;
        }
        return isEqual;
    }

    public boolean isChanged() {
        return !this.isUnchanged();
    }

    protected void internalReset() {
        this.lineParts.clear();
    }

    public final List<LinePart> getLineParts() {
        return this.lineParts;
    }

    public void addLinePart(LinePart linePart) {
        this.lineParts.add(linePart);
    }

    public String getText() {
        StringBuilder result = new StringBuilder();
        for (LinePart linePart : this.getLineParts()) {
            result.append(linePart.getText());
        }
        return result.toString();
    }

    public String toString() {
        return this.getText();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractLine)) {
            return false;
        }
        return this.equalsLine((AbstractLine)obj);
    }

    private boolean equalsLine(AbstractLine other) {
        List<LinePart> myParts = this.getLineParts();
        List<LinePart> otherParts = other.getLineParts();
        return myParts.equals(otherParts);
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getText());
        return sb.toString().hashCode();
    }

    public boolean hasEndOfLine() {
        List<LinePart> parts = this.getLineParts();
        if (parts.isEmpty()) {
            return false;
        }
        LinePart part = parts.get(parts.size() - 1);
        return part.isNL();
    }
}

