/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.config.diff.filediff;

import com.top_logic.config.diff.filediff.AbstractLine;
import com.top_logic.config.diff.filediff.FileDiff;
import com.top_logic.config.diff.filediff.Line;
import com.top_logic.config.diff.filediff.ListQueue;
import com.top_logic.config.diff.filediff.Region;
import java.util.ArrayList;
import java.util.List;

public final class DiffBuilder {
    private List<Region> regions;
    private Region current;

    public FileDiff createDiff(List<Line> sourceLines, List<Line> destLines) {
        this.regions = new ArrayList<Region>();
        this.current = null;
        ListQueue<Line> srcQueue = new ListQueue<Line>(sourceLines);
        ListQueue<Line> dstQueue = new ListQueue<Line>(destLines);
        if (!srcQueue.isEmpty() || !dstQueue.isEmpty()) {
            while (true) {
                AbstractLine srcLine = (AbstractLine)srcQueue.peekOrNull();
                AbstractLine dstLine = (AbstractLine)dstQueue.peekOrNull();
                if (srcLine == null && dstLine == null) break;
                int comparison = this.compare(srcLine, dstLine);
                if (comparison == 0) {
                    this.produceUnchangedLine(srcLine);
                    srcQueue.pop();
                    dstQueue.pop();
                    continue;
                }
                if (comparison < 0) {
                    this.produceChangedRegion().addSourceLine(srcLine);
                    srcQueue.pop();
                    continue;
                }
                this.produceChangedRegion().addDestLine(dstLine);
                dstQueue.pop();
            }
        }
        return new FileDiff(this.regions);
    }

    private int compare(AbstractLine srcLine, AbstractLine dstLine) {
        int dstIndex;
        if (srcLine == null) {
            return 1;
        }
        if (dstLine == null) {
            return -1;
        }
        int srcIndex = srcLine.getLineParts().get(0).getDiffIndex();
        if (srcIndex < (dstIndex = dstLine.getLineParts().get(0).getDiffIndex())) {
            return -1;
        }
        if (srcIndex > dstIndex) {
            return 1;
        }
        if (srcLine.equals(dstLine)) {
            return 0;
        }
        return -1;
    }

    private void produceUnchangedLine(AbstractLine srcLine) {
        if (this.isFirst() || this.current.isChanged()) {
            this.addRegion(new Region(false));
        }
        this.current.addSourceLine(srcLine);
        this.current.addDestLine(srcLine);
    }

    private Region produceChangedRegion() {
        if (this.isFirst() || !this.current.isChanged()) {
            this.addRegion(new Region(true));
        }
        return this.current;
    }

    protected boolean isFirst() {
        return this.current == null;
    }

    private void addRegion(Region region) {
        this.regions.add(region);
        this.current = region;
    }
}

