/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.config.diff;

import com.top_logic.config.diff.filediff.FileDiff;
import com.top_logic.config.diff.filediff.FileDiffGenerator;
import com.top_logic.config.diff.filediff.Region;
import com.top_logic.config.diff.zip.ZipReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompareStatistics {
    private ZipReader.EntryResult entryResult = null;
    private CompareStatistics parent = null;
    private Set<CompareStatistics> seenChildren = null;
    private Set<Integer> seenChangedRegions = null;
    private int currentChangedRegion;
    private boolean hasChanges;
    private int numOfRegions = 0;
    private int numOfUnchangedRegions = 0;
    private int numOfChangedRegions = 0;
    private int numOfSourceLines = 0;
    private int numOfDestLines = 0;
    private int numOfChangedSourceLines = 0;
    private int numOfUnchangedSourceLines = 0;
    private int numOfChangedDestLines = 0;
    private int numOfUnchangedDestLines = 0;
    private boolean initialized = false;
    private boolean allChangesSeen = false;
    private boolean allChildrenSeen = false;

    public CompareStatistics() {
        this.seenChangedRegions = new HashSet<Integer>();
        this.currentChangedRegion = -1;
    }

    public CompareStatistics(ZipReader.EntryResult entryResult) {
        this.setEntryResult(entryResult);
        this.setChanged(!ZipReader.EntryResult.State.NO_CHANGE.equals((Object)entryResult.getState()));
        this.seenChangedRegions = new HashSet<Integer>();
        this.seenChildren = new HashSet<CompareStatistics>();
        this.currentChangedRegion = -1;
        if (!entryResult.isDirectory()) {
            this.setAllChildrenSeen(true);
        }
        if (this.getEntryResult().getParent() != null) {
            CompareStatistics parentsStatistics = this.getEntryResult().getParent().getStatistics();
            this.setParent(parentsStatistics);
        }
        if (this.getState().equals((Object)ZipReader.EntryResult.State.NO_CHANGE) && this.getParent() != null) {
            this.getParent().allMyChangesAreSeen(this);
            this.setAllChangesSeen(true);
        }
    }

    public void findChanges(FileDiff fileDiff) {
        boolean notFound = true;
        List<Region> regions = fileDiff.getRegions();
        this.setNumOfRegions(regions.size());
        for (Region region : regions) {
            int numOfSourceLinesInRegion = region.getSourceLines().size();
            this.numOfSourceLines += numOfSourceLinesInRegion;
            int numOfDestLinesInRegion = region.getDestLines().size();
            this.numOfDestLines += numOfDestLinesInRegion;
            if (region.isChanged()) {
                ++this.numOfChangedRegions;
                this.numOfChangedSourceLines += numOfSourceLinesInRegion;
                this.numOfChangedDestLines += numOfDestLinesInRegion;
                if (!notFound) continue;
                this.setChanged(true);
                notFound = false;
                continue;
            }
            ++this.numOfUnchangedRegions;
            this.numOfUnchangedSourceLines += numOfSourceLinesInRegion;
            this.numOfUnchangedDestLines += numOfDestLinesInRegion;
        }
    }

    public FileDiff getFileDiff() {
        String sourceText = this.getEntryResult().getSource();
        String destText = this.getEntryResult().getDest();
        FileDiff fileDiff = FileDiffGenerator.INSTANCE.generate(sourceText, destText);
        if (!this.initialized) {
            this.findChanges(fileDiff);
            this.initialized = true;
        }
        return fileDiff;
    }

    public String getHTML(String aSource, String aDest) {
        return FileDiffGenerator.INSTANCE.generateHtmlToString(this.getFileDiff(), aSource, aDest, this);
    }

    public void setEntryResult(ZipReader.EntryResult entryResult) {
        this.entryResult = entryResult;
    }

    public boolean hasChanges() {
        boolean result = this.hasChanges;
        return result;
    }

    private void setChanged(boolean changed) {
        this.hasChanges = changed;
    }

    public ZipReader.EntryResult getEntryResult() {
        return this.entryResult;
    }

    public String getName() {
        return this.getEntryResult().getPlainName();
    }

    public int getNumOfRegions() {
        return this.numOfRegions;
    }

    private void setNumOfRegions(int numOfRegions) {
        this.numOfRegions = numOfRegions;
    }

    public int getNumOfUnchangedRegions() {
        return this.numOfUnchangedRegions;
    }

    public int getNumOfSourceLines() {
        return this.numOfSourceLines;
    }

    public int getNumOfDestLines() {
        return this.numOfDestLines;
    }

    public int getNumOfChangedSourceLines() {
        return this.numOfChangedSourceLines;
    }

    public ZipReader.EntryResult.State getState() {
        return this.entryResult.getState();
    }

    public String getStateAsString() {
        return this.entryResult.getStateAsString();
    }

    public int getNumOfUnchangedSourceLines() {
        return this.numOfUnchangedSourceLines;
    }

    public int getNumOfChangedDestLines() {
        return this.numOfChangedDestLines;
    }

    public int getNumOfUnchangedDestLines() {
        return this.numOfUnchangedDestLines;
    }

    public int getNumOfChangedRegions() {
        return this.numOfChangedRegions;
    }

    public void setNumOfChangedRegions(int numOfChangedRegions) {
        this.numOfChangedRegions = numOfChangedRegions;
    }

    public void markChangedRegionAsEvaluated(int regionID) {
        if (regionID < 1) {
            throw new IllegalArgumentException("regionID=" + regionID + ", must be greater than zero");
        }
        if (regionID > this.numOfChangedRegions) {
            throw new IllegalArgumentException("regionID=" + regionID + ", numOfChangedRegions=" + this.numOfChangedRegions + ", regionsID must be less or equal numOfChangedRegions");
        }
        this.seenChangedRegions.add(regionID);
        this.validateAllChangesSeen();
    }

    public boolean isEvaluatedChangedRegion(int regionID) {
        return this.seenChangedRegions.contains(regionID);
    }

    public int getCurrentChangedRegion() {
        return this.currentChangedRegion;
    }

    public void setCurrentChangedRegion(int currentChangedRegion) {
        this.currentChangedRegion = currentChangedRegion;
    }

    protected void validateAllChangesSeen() {
        if (this.getEntryResult().isDirectory()) {
            if (this.getNumOfChildren() == this.seenChildren.size()) {
                this.setAllChangesSeen(true);
                this.setAllChildrenSeen(true);
                CompareStatistics parent2 = this.getParent();
                if (parent2 != null) {
                    parent2.allMyChangesAreSeen(this);
                }
            }
        } else if (this.seenChangedRegions.size() == this.getNumOfChangedRegions()) {
            this.setAllChangesSeen(true);
            CompareStatistics parent2 = this.getParent();
            if (parent2 != null) {
                parent2.allMyChangesAreSeen(this);
            }
        }
    }

    public boolean areAllChangesSeen() {
        return this.allChangesSeen;
    }

    public void setAllChangesSeen(boolean allChangesSeen) {
        this.allChangesSeen = allChangesSeen;
    }

    public boolean isEntryDirectory() {
        return this.getEntryResult().isDirectory();
    }

    public boolean areAllChildrenSeen() {
        assert (this.getEntryResult().isDirectory());
        return this.allChildrenSeen;
    }

    public void allMyChangesAreSeen(CompareStatistics statistics) {
        this.seenChildren.add(statistics);
        this.validateAllChangesSeen();
    }

    public void setAllChildrenSeen(boolean allChildrenSeen) {
        this.allChildrenSeen = allChildrenSeen;
    }

    public CompareStatistics getParent() {
        return this.parent;
    }

    public void setParent(CompareStatistics parent) {
        this.parent = parent;
    }

    public int getNumOfChildren() {
        return this.entryResult.getChildren().size();
    }

    public Set<Integer> getSeenChangedRegions() {
        return this.seenChangedRegions;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Set<CompareStatistics> getSeenChildren() {
        return this.seenChildren;
    }

    public void setAndMarkCurrentChangedRegion(int numOfRegion) {
        this.setCurrentChangedRegion(numOfRegion);
        this.markChangedRegionAsEvaluated(numOfRegion);
    }

    public void setSeenChangedRegions(Set<Integer> seenChangedRegions) {
        this.seenChangedRegions = seenChangedRegions;
    }
}

