/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.config.diff;

import com.top_logic.config.diff.RootCompareStatistic;
import com.top_logic.config.diff.filediff.FileDiff;
import com.top_logic.config.diff.filediff.FileDiffGenerator;

public class SimpleTextDiff {
    RootCompareStatistic statistic = null;
    String text1 = null;
    String text2 = null;
    String tableHeadText1 = null;
    String tableHeadText2 = null;

    public SimpleTextDiff(String text1, String text2, String tableHeadText1, String tableHeadText2) {
        this.setText1(text1);
        this.setText2(text2);
        this.setTableHeadText1(tableHeadText1);
        this.setTableHeadText2(tableHeadText2);
        this.statistic = new RootCompareStatistic();
        this.initializeStatistic();
    }

    public String getHTML(boolean markViewedChange) {
        return new FileDiffGenerator(markViewedChange).generateHtmlToString(this.getFileDiff(), this.getTableHeadText1(), this.getTableHeadText2(), this.getStatistic());
    }

    public FileDiff getFileDiff() {
        return new FileDiffGenerator().generate(this.getText1(), this.getText2());
    }

    private void initializeStatistic() {
        RootCompareStatistic theStatistic = this.getStatistic();
        theStatistic.findChanges(this.getFileDiff());
        if (theStatistic.getNumOfChangedRegions() > 0) {
            theStatistic.setCurrentChangedRegion(1);
            theStatistic.getSeenChangedRegions().add(1);
        }
    }

    public RootCompareStatistic getStatistic() {
        return this.statistic;
    }

    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    public String getTableHeadText1() {
        return this.tableHeadText1;
    }

    public void setTableHeadText1(String tableHeadText1) {
        this.tableHeadText1 = tableHeadText1;
    }

    public String getTableHeadText2() {
        return this.tableHeadText2;
    }

    public void setTableHeadText2(String tableHeadText2) {
        this.tableHeadText2 = tableHeadText2;
    }
}

