/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.config.diff.filediff;

import com.top_logic.basic.Configuration;
import com.top_logic.basic.xml.TagWriter;
import com.top_logic.config.diff.CompareStatistics;
import com.top_logic.config.diff.RootCompareStatistic;
import com.top_logic.config.diff.filediff.AbstractLine;
import com.top_logic.config.diff.filediff.DiffBuilder;
import com.top_logic.config.diff.filediff.FileDiff;
import com.top_logic.config.diff.filediff.LinePart;
import com.top_logic.config.diff.filediff.NLPart;
import com.top_logic.config.diff.filediff.Region;
import com.top_logic.config.diff.filediff.TempLine;
import com.top_logic.config.diff.filediff.TextPart;
import com.top_logic.config.diff.google.diff_match_patch;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileDiffGenerator {
    private static final String PREFIX = "ConfigDiff";
    private static final String SEEN = "ConfigDiffSeen";
    private static final String UNSEEN = "ConfigDiffUnseen";
    private static final String INSERT = "ConfigDiffInsert";
    private static final String DELETE = "ConfigDiffDelete";
    private static final String UNCHANGED_LINE_D = "ConfigDiffUnchangedLineD";
    private static final String CHANGED_LINE_D = "ConfigDiffChangedLineD";
    private static final String UNCHANGED_LINE_NUMBER_D = "ConfigDiffUnchangedLineNumberD";
    private static final String CHANGED_LINE_NUMBER_D = "ConfigDiffChangedLineNumberD";
    private static final String UNCHANGED_LINE_NUMBER_S = "ConfigDiffUnchangedLineNumberS";
    private static final String CHANGED_LINE_NUMBER_S = "ConfigDiffChangedLineNumberS";
    private static final String UNCHANGED_LINE_S = "ConfigDiffUnchangedLineS";
    private static final String CHANGED_LINE_S = "ConfigDiffChangedLineS";
    private static final String HIGHLIGHTED = "ConfigDiffHighlighted";
    private static final String HIGHLIGHTED_LR = "ConfigDiffHighlightedLR";
    public static final String ANCHOR_PREFIX = "CHANGED_REGION_";
    public static final String END_PREFIX = "END_CHANGED_REGION_";
    public static final String CHANGED_TABLEROW_PREFIX = "TABLEROW_CHANGED_REGION_";
    public static final String TABLE_ROW = "ConfigDiff";
    public static final String TABLE_HEAD = "ConfigDiff";
    public static final String TABLE_HEAD_LR = "ConfigDiffTHLR";
    public static final String DIFF_TABLE = "ConfigDiffTable";
    private boolean markViewedChange;
    public static FileDiffGenerator INSTANCE = new FileDiffGenerator();

    public FileDiffGenerator() {
        this(true);
    }

    public FileDiffGenerator(boolean markViewedChange) {
        this.markViewedChange = markViewedChange;
    }

    public FileDiff generate(String sourceText, String destText) {
        List<LinePart> normalizedDiffs = this.getNormalization(sourceText, destText);
        return this.generateFileDiff(normalizedDiffs);
    }

    public List<LinePart> getNormalization(String sourceText, String destText) {
        if (sourceText == null) {
            sourceText = "";
        }
        if (destText == null) {
            destText = "";
        }
        List<diff_match_patch.Diff> diffMatchPatchDiffs = this.computeDiffMatchPatchDiffs(sourceText, destText);
        return this.normalize(diffMatchPatchDiffs);
    }

    private List<LinePart> normalize(List<diff_match_patch.Diff> diffs) {
        ArrayList<LinePart> lineParts = new ArrayList<LinePart>();
        int diffIndex = 0;
        for (diff_match_patch.Diff diff : diffs) {
            String text = diff.text;
            Matcher nlMatcher = Pattern.compile("\r?\n|\r").matcher(text);
            int textStart = 0;
            while (textStart < text.length()) {
                boolean textFound;
                boolean nlFound = nlMatcher.find();
                int textEnd = nlFound ? nlMatcher.start() : text.length();
                boolean bl = textFound = textEnd > textStart;
                if (textFound) {
                    lineParts.add(new TextPart(text.substring(textStart, textEnd), diff.operation, diffIndex));
                }
                if (nlFound) {
                    int nlEnd = nlMatcher.end();
                    lineParts.add(new NLPart(text.substring(textEnd, nlEnd), diff.operation, diffIndex));
                    textStart = nlEnd;
                    continue;
                }
                textStart = textEnd;
            }
            ++diffIndex;
        }
        return lineParts;
    }

    public FileDiff generateFileDiff(List<LinePart> lineParts) {
        TempLine.TempSourceLine tempSourceLine = new TempLine.TempSourceLine();
        TempLine.TempDestLine tempDestLine = new TempLine.TempDestLine();
        for (LinePart part : lineParts) {
            tempSourceLine.offerLinePart(part);
            tempDestLine.offerLinePart(part);
        }
        tempSourceLine.flush();
        tempDestLine.flush();
        return new DiffBuilder().createDiff(tempSourceLine.getProducedLines(), tempDestLine.getProducedLines());
    }

    private List<diff_match_patch.Diff> computeDiffMatchPatchDiffs(String sourceText, String destText) {
        diff_match_patch theDiffMatchPatch = new diff_match_patch();
        theDiffMatchPatch.Diff_Timeout = this.getTimeOut();
        LinkedList<diff_match_patch.Diff> diffs = theDiffMatchPatch.diff_main(sourceText, destText, false);
        return diffs;
    }

    private int getTimeOut() {
        String theValue = Configuration.getConfiguration(FileDiffGenerator.class).getValue("diffTimeOut", "10");
        return Integer.valueOf(theValue);
    }

    public String generateHtmlToString(FileDiff aFileDiff, String aSource, String aDest, CompareStatistics aStatistic) {
        StringWriter theWriter = new StringWriter();
        this.doWriteHTML(aFileDiff, theWriter, aSource, aDest, aStatistic);
        return theWriter.getBuffer().toString();
    }

    public void generateHtmlToFile(FileDiff aFileDiff, String fileNameWithPath, String aSource, String aDest) {
        this.generateHtmlToFile(aFileDiff, fileNameWithPath, "ISO-8859-1", aSource, aDest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateHtmlToFile(FileDiff aFileDiff, String fileNameWithPath, String encoding, String aSource, String aDest) {
        try (FileOutputStream stream = new FileOutputStream(fileNameWithPath);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, encoding);){
            this.doWriteHTML(aFileDiff, writer, aSource, aDest, new RootCompareStatistic());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doWriteHTML(FileDiff aFileDiff, Writer writer, String aSource, String aDest, CompareStatistics aStatistic) {
        try {
            if (aStatistic.getCurrentChangedRegion() == -1 && aStatistic.getNumOfChangedRegions() > 0) {
                aStatistic.setCurrentChangedRegion(1);
                aStatistic.markChangedRegionAsEvaluated(1);
            }
            TagWriter tw = new TagWriter(writer);
            tw.setIndent(false);
            tw.beginBeginTag("table");
            tw.writeAttribute("class", (CharSequence)DIFF_TABLE);
            tw.writeAttribute("cellspacing", (CharSequence)"0");
            tw.writeAttribute("width", (CharSequence)"100%");
            tw.endBeginTag();
            tw.beginTag("tr");
            tw.beginBeginTag("th");
            tw.writeAttribute("class", (CharSequence)"ConfigDiff");
            tw.writeAttribute("width", (CharSequence)"36");
            tw.endBeginTag();
            tw.writeText((CharSequence)"#");
            tw.endTag("th");
            tw.beginBeginTag("th");
            tw.writeAttribute("class", (CharSequence)TABLE_HEAD_LR);
            tw.writeAttribute("width", (CharSequence)"44%");
            tw.endBeginTag();
            tw.writeText((CharSequence)aSource);
            tw.endTag("th");
            tw.beginBeginTag("th");
            tw.writeAttribute("class", (CharSequence)"ConfigDiff");
            tw.writeAttribute("width", (CharSequence)"10");
            tw.endBeginTag();
            tw.writeText((CharSequence)"C");
            tw.endTag("th");
            tw.beginBeginTag("th");
            tw.writeAttribute("class", (CharSequence)TABLE_HEAD_LR);
            tw.writeAttribute("width", (CharSequence)"36");
            tw.endBeginTag();
            tw.writeText((CharSequence)"#");
            tw.endTag("th");
            tw.beginBeginTag("th");
            tw.writeAttribute("class", (CharSequence)"ConfigDiff");
            tw.writeAttribute("width", (CharSequence)"44%");
            tw.endBeginTag();
            tw.writeText((CharSequence)aDest);
            tw.endTag("th");
            tw.endTag("tr");
            int sourceLineCounter = 1;
            int destLineCounter = 1;
            int anchorCounter = 0;
            int changedRegionCounter = 0;
            List<Region> regions = aFileDiff.getRegions();
            block2: for (Region region : regions) {
                if (region.isChanged()) {
                    ++changedRegionCounter;
                }
                boolean anchorSet = false;
                int linesInRegion = region.getSourceLines().size() >= region.getDestLines().size() ? region.getSourceLines().size() : region.getDestLines().size();
                int lineCounter = 0;
                if (region.isChanged() && !anchorSet) {
                    ++anchorCounter;
                }
                List<AbstractLine> sourceLines = region.getSourceLines();
                Iterator<AbstractLine> sourceLinesIterator = sourceLines.iterator();
                List<AbstractLine> destLines = region.getDestLines();
                Iterator<AbstractLine> destLinesIterator = destLines.iterator();
                boolean printSourceLine = true;
                boolean printDestLine = true;
                boolean hasSourceLine = false;
                boolean hasDestLine = false;
                AbstractLine sourceLine = null;
                AbstractLine destLine = null;
                while (true) {
                    if (printSourceLine) {
                        hasSourceLine = sourceLinesIterator.hasNext();
                        sourceLine = hasSourceLine ? sourceLinesIterator.next() : null;
                    }
                    if (printDestLine) {
                        hasDestLine = destLinesIterator.hasNext();
                        destLine = hasDestLine ? destLinesIterator.next() : null;
                    }
                    if (!hasSourceLine && !hasDestLine) continue block2;
                    ++lineCounter;
                    printSourceLine = hasSourceLine ? sourceLine.getLineParts().get(0).getDstLine() <= destLineCounter || destLine == null : false;
                    printDestLine = hasDestLine ? destLine.getLineParts().get(0).getSrcLine() <= sourceLineCounter || sourceLine == null : false;
                    if (!printSourceLine && !printDestLine) {
                        throw new AssertionError((Object)"Invalid regions.");
                    }
                    tw.beginTag("tr");
                    tw.beginBeginTag("td");
                    tw.writeAttribute("valign", (CharSequence)"top");
                    if (region.isChanged()) {
                        tw.writeAttribute("class", (CharSequence)CHANGED_LINE_NUMBER_S);
                    } else {
                        tw.writeAttribute("class", (CharSequence)UNCHANGED_LINE_NUMBER_S);
                    }
                    tw.endBeginTag();
                    if (region.isChanged() && !anchorSet) {
                        String regionID = ANCHOR_PREFIX + anchorCounter;
                        tw.beginBeginTag("a");
                        tw.writeAttribute("id", (CharSequence)regionID);
                        tw.endEmptyTag();
                        anchorSet = true;
                    }
                    if (region.isChanged() && lineCounter == linesInRegion) {
                        String endRegionID = END_PREFIX + anchorCounter;
                        tw.beginBeginTag("a");
                        tw.writeAttribute("id", (CharSequence)endRegionID);
                        tw.endEmptyTag();
                    }
                    if (printSourceLine) {
                        tw.writeText((CharSequence)("" + sourceLineCounter));
                    }
                    tw.endTag("td");
                    tw.beginBeginTag("td");
                    tw.writeAttribute("valign", (CharSequence)"top");
                    if (region.isChanged()) {
                        tw.writeAttribute("class", (CharSequence)CHANGED_LINE_S);
                    } else {
                        tw.writeAttribute("class", (CharSequence)UNCHANGED_LINE_S);
                    }
                    tw.endBeginTag();
                    if (printSourceLine) {
                        this.markChangesInLine(tw, sourceLine);
                    }
                    tw.endTag("td");
                    tw.beginBeginTag("td");
                    tw.writeAttribute("valign", (CharSequence)"top");
                    if (region.isChanged() && !aStatistic.getSeenChangedRegions().contains(changedRegionCounter)) {
                        tw.writeAttribute("class", (CharSequence)UNSEEN);
                    } else {
                        tw.writeAttribute("class", (CharSequence)SEEN);
                    }
                    tw.endBeginTag();
                    tw.writeText((CharSequence)"\u00a0");
                    tw.endTag("td");
                    tw.beginBeginTag("td");
                    tw.writeAttribute("valign", (CharSequence)"top");
                    if (region.isChanged()) {
                        tw.writeAttribute("class", (CharSequence)CHANGED_LINE_NUMBER_D);
                    } else {
                        tw.writeAttribute("class", (CharSequence)UNCHANGED_LINE_NUMBER_D);
                    }
                    tw.endBeginTag();
                    if (printDestLine) {
                        tw.writeText((CharSequence)("" + destLineCounter));
                    }
                    tw.endTag("td");
                    tw.beginBeginTag("td");
                    tw.writeAttribute("valign", (CharSequence)"top");
                    if (region.isChanged()) {
                        tw.writeAttribute("class", (CharSequence)CHANGED_LINE_D);
                    } else {
                        tw.writeAttribute("class", (CharSequence)UNCHANGED_LINE_D);
                    }
                    tw.endBeginTag();
                    if (printDestLine) {
                        this.markChangesInLine(tw, destLine);
                    }
                    tw.endTag("td");
                    tw.endTag("tr");
                    if (printSourceLine) {
                        ++sourceLineCounter;
                    }
                    if (!printDestLine) continue;
                    ++destLineCounter;
                }
            }
            tw.endTag("table");
            if (this.markViewedChange) {
                tw.beginScript();
                tw.append((CharSequence)("jumpToRegion('CHANGED_REGION_" + aStatistic.getCurrentChangedRegion() + "', " + aStatistic.getCurrentChangedRegion() + ", " + aStatistic.getNumOfChangedRegions() + ");"));
                tw.endScript();
            }
            tw.flush();
            tw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void markChangesInLine(TagWriter tw, AbstractLine line) throws IOException {
        if (!line.isUnchanged()) {
            for (LinePart linePart : line.getLineParts()) {
                String text = linePart.getText();
                if (linePart.getOperation().equals((Object)diff_match_patch.Operation.DELETE)) {
                    tw.beginBeginTag("span");
                    tw.writeAttribute("class", (CharSequence)DELETE);
                    tw.endBeginTag();
                    this.writeContentText(tw, this.showNewlines(text));
                    tw.endTag("span");
                    continue;
                }
                if (linePart.getOperation().equals((Object)diff_match_patch.Operation.INSERT)) {
                    tw.beginBeginTag("span");
                    tw.writeAttribute("class", (CharSequence)INSERT);
                    tw.endBeginTag();
                    this.writeContentText(tw, this.showNewlines(text));
                    tw.endTag("span");
                    continue;
                }
                this.writeContentText(tw, this.hideNewLine(text));
            }
        } else {
            this.writeContentText(tw, this.hideNewLine(line.getText()));
        }
    }

    private String hideNewLine(String text) {
        return text.replaceAll("\r|\n", "");
    }

    private String showNewlines(String text) {
        return text.replaceAll("\r", "\u240d").replaceAll("\n", "\u240a");
    }

    private void writeContentText(TagWriter tw, String text) throws IOException {
        tw.writeText((CharSequence)text.replaceAll(" ", "\u00a0").replaceAll("\t", "\u00a0\u00a0\u00a0\u00a0"));
    }
}

