/*
 * Decompiled with CFR 0.152.
 */
package com.top_logic.config.diff.filediff;

import com.top_logic.config.diff.filediff.AbstractLine;
import com.top_logic.config.diff.filediff.Line;
import com.top_logic.config.diff.filediff.LinePart;
import com.top_logic.config.diff.google.diff_match_patch;
import java.util.ArrayList;
import java.util.List;

public abstract class TempLine
extends AbstractLine {
    private boolean crSeen;
    private List<Line> producedLines = new ArrayList<Line>();
    protected int lineIndex = 1;

    public void offerLinePart(LinePart part) {
        if (this.accepts(part.getOperation())) {
            if (part.isNL()) {
                boolean isCr = part.getText().equals("\r");
                if (isCr) {
                    if (this.crSeen) {
                        this.flushLine();
                        this.addLinePart(part);
                    } else {
                        this.addLinePart(part);
                        this.crSeen = true;
                    }
                } else if (this.crSeen) {
                    boolean isLf = part.getText().equals("\n");
                    if (isLf) {
                        this.addLinePart(part);
                        this.flushLine();
                    } else {
                        this.flushLine();
                        this.addLinePart(part);
                        this.flushLine();
                    }
                    this.crSeen = false;
                } else {
                    this.addLinePart(part);
                    this.flushLine();
                }
            } else {
                if (this.crSeen) {
                    this.flushLine();
                    this.crSeen = false;
                }
                this.addLinePart(part);
            }
        } else {
            this.annotateLine(part);
        }
    }

    public void flush() {
        if (!this.getLineParts().isEmpty()) {
            this.flushLine();
        }
    }

    private void flushLine() {
        Line producedLine = new Line(this);
        this.producedLines.add(producedLine);
        ++this.lineIndex;
        this.internalReset();
    }

    public List<Line> getProducedLines() {
        return this.producedLines;
    }

    protected abstract boolean accepts(diff_match_patch.Operation var1);

    protected abstract void annotateLine(LinePart var1);

    public boolean isEmpty() {
        return this.getLineParts().isEmpty();
    }

    public static class TempDestLine
    extends TempLine {
        @Override
        protected boolean accepts(diff_match_patch.Operation operation) {
            return diff_match_patch.Operation.EQUAL == operation || diff_match_patch.Operation.INSERT == operation;
        }

        @Override
        public void addLinePart(LinePart linePart) {
            super.addLinePart(linePart);
            this.annotateLine(linePart);
        }

        @Override
        protected void annotateLine(LinePart linePart) {
            linePart.setDestLine(this.lineIndex);
        }
    }

    public static class TempSourceLine
    extends TempLine {
        @Override
        protected boolean accepts(diff_match_patch.Operation operation) {
            return diff_match_patch.Operation.EQUAL == operation || diff_match_patch.Operation.DELETE == operation;
        }

        @Override
        public void addLinePart(LinePart linePart) {
            super.addLinePart(linePart);
            this.annotateLine(linePart);
        }

        @Override
        protected void annotateLine(LinePart linePart) {
            linePart.setSrcLine(this.lineIndex);
        }
    }
}

